package ververica

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDeployments invokes the ververica.ListDeployments API synchronously
func (client *Client) ListDeployments(request *ListDeploymentsRequest) (response *ListDeploymentsResponse, err error) {
	response = CreateListDeploymentsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDeploymentsWithChan invokes the ververica.ListDeployments API asynchronously
func (client *Client) ListDeploymentsWithChan(request *ListDeploymentsRequest) (<-chan *ListDeploymentsResponse, <-chan error) {
	responseChan := make(chan *ListDeploymentsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDeployments(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDeploymentsWithCallback invokes the ververica.ListDeployments API asynchronously
func (client *Client) ListDeploymentsWithCallback(request *ListDeploymentsRequest, callback func(response *ListDeploymentsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDeploymentsResponse
		var err error
		defer close(result)
		response, err = client.ListDeployments(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDeploymentsRequest is the request struct for api ListDeployments
type ListDeploymentsRequest struct {
	*requests.RoaRequest
	Workspace    string           `position:"Path" name:"workspace"`
	Creator      string           `position:"Query" name:"creator"`
	Modifier     string           `position:"Query" name:"modifier"`
	Priority     string           `position:"Query" name:"priority"`
	BatchMode    requests.Boolean `position:"Query" name:"batchMode"`
	SortName     string           `position:"Query" name:"sortName"`
	DeploymentId string           `position:"Query" name:"deploymentId"`
	Namespace    string           `position:"Path" name:"namespace"`
	PageSize     string           `position:"Query" name:"pageSize"`
	Name         string           `position:"Query" name:"name"`
	PageIndex    string           `position:"Query" name:"pageIndex"`
	SortOrder    string           `position:"Query" name:"sortOrder"`
	State        string           `position:"Query" name:"state"`
	Status       string           `position:"Query" name:"status"`
}

// ListDeploymentsResponse is the response struct for api ListDeployments
type ListDeploymentsResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"success" xml:"success"`
	Data      string `json:"data" xml:"data"`
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateListDeploymentsRequest creates a request to invoke ListDeployments API
func CreateListDeploymentsRequest() (request *ListDeploymentsRequest) {
	request = &ListDeploymentsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("ververica", "2020-05-01", "ListDeployments", "/pop/workspaces/[workspace]/api/v1/namespaces/[namespace]/deployments", "", "")
	request.Method = requests.GET
	return
}

// CreateListDeploymentsResponse creates a response to parse from ListDeployments response
func CreateListDeploymentsResponse() (response *ListDeploymentsResponse) {
	response = &ListDeploymentsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
