package tag

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckCreatedByEnabled invokes the tag.CheckCreatedByEnabled API synchronously
func (client *Client) CheckCreatedByEnabled(request *CheckCreatedByEnabledRequest) (response *CheckCreatedByEnabledResponse, err error) {
	response = CreateCheckCreatedByEnabledResponse()
	err = client.DoAction(request, response)
	return
}

// CheckCreatedByEnabledWithChan invokes the tag.CheckCreatedByEnabled API asynchronously
func (client *Client) CheckCreatedByEnabledWithChan(request *CheckCreatedByEnabledRequest) (<-chan *CheckCreatedByEnabledResponse, <-chan error) {
	responseChan := make(chan *CheckCreatedByEnabledResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckCreatedByEnabled(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckCreatedByEnabledWithCallback invokes the tag.CheckCreatedByEnabled API asynchronously
func (client *Client) CheckCreatedByEnabledWithCallback(request *CheckCreatedByEnabledRequest, callback func(response *CheckCreatedByEnabledResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckCreatedByEnabledResponse
		var err error
		defer close(result)
		response, err = client.CheckCreatedByEnabled(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckCreatedByEnabledRequest is the request struct for api CheckCreatedByEnabled
type CheckCreatedByEnabledRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      string           `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CheckCreatedByEnabledResponse is the response struct for api CheckCreatedByEnabled
type CheckCreatedByEnabledResponse struct {
	*responses.BaseResponse
	OpenStatus bool   `json:"OpenStatus" xml:"OpenStatus"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateCheckCreatedByEnabledRequest creates a request to invoke CheckCreatedByEnabled API
func CreateCheckCreatedByEnabledRequest() (request *CheckCreatedByEnabledRequest) {
	request = &CheckCreatedByEnabledRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Tag", "2018-08-28", "CheckCreatedByEnabled", "tag", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCheckCreatedByEnabledResponse creates a response to parse from CheckCreatedByEnabled response
func CreateCheckCreatedByEnabledResponse() (response *CheckCreatedByEnabledResponse) {
	response = &CheckCreatedByEnabledResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
