package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDisks invokes the swas_open.ListDisks API synchronously
func (client *Client) ListDisks(request *ListDisksRequest) (response *ListDisksResponse, err error) {
	response = CreateListDisksResponse()
	err = client.DoAction(request, response)
	return
}

// ListDisksWithChan invokes the swas_open.ListDisks API asynchronously
func (client *Client) ListDisksWithChan(request *ListDisksRequest) (<-chan *ListDisksResponse, <-chan error) {
	responseChan := make(chan *ListDisksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDisks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDisksWithCallback invokes the swas_open.ListDisks API asynchronously
func (client *Client) ListDisksWithCallback(request *ListDisksRequest, callback func(response *ListDisksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDisksResponse
		var err error
		defer close(result)
		response, err = client.ListDisks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDisksRequest is the request struct for api ListDisks
type ListDisksRequest struct {
	*requests.RpcRequest
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	ResourceGroupId string           `position:"Query" name:"ResourceGroupId"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	DiskIds         string           `position:"Query" name:"DiskIds"`
	Tag             *[]ListDisksTag  `position:"Query" name:"Tag"  type:"Repeated"`
	DiskType        string           `position:"Query" name:"DiskType"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
}

// ListDisksTag is a repeated param struct in ListDisksRequest
type ListDisksTag struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListDisksResponse is the response struct for api ListDisks
type ListDisksResponse struct {
	*responses.BaseResponse
	TotalCount int    `json:"TotalCount" xml:"TotalCount"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
	PageSize   int    `json:"PageSize" xml:"PageSize"`
	PageNumber int    `json:"PageNumber" xml:"PageNumber"`
	Disks      []Disk `json:"Disks" xml:"Disks"`
}

// CreateListDisksRequest creates a request to invoke ListDisks API
func CreateListDisksRequest() (request *ListDisksRequest) {
	request = &ListDisksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "ListDisks", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDisksResponse creates a response to parse from ListDisks response
func CreateListDisksResponse() (response *ListDisksResponse) {
	response = &ListDisksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
