package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// InstallCloudMonitorAgent invokes the swas_open.InstallCloudMonitorAgent API synchronously
func (client *Client) InstallCloudMonitorAgent(request *InstallCloudMonitorAgentRequest) (response *InstallCloudMonitorAgentResponse, err error) {
	response = CreateInstallCloudMonitorAgentResponse()
	err = client.DoAction(request, response)
	return
}

// InstallCloudMonitorAgentWithChan invokes the swas_open.InstallCloudMonitorAgent API asynchronously
func (client *Client) InstallCloudMonitorAgentWithChan(request *InstallCloudMonitorAgentRequest) (<-chan *InstallCloudMonitorAgentResponse, <-chan error) {
	responseChan := make(chan *InstallCloudMonitorAgentResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.InstallCloudMonitorAgent(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// InstallCloudMonitorAgentWithCallback invokes the swas_open.InstallCloudMonitorAgent API asynchronously
func (client *Client) InstallCloudMonitorAgentWithCallback(request *InstallCloudMonitorAgentRequest, callback func(response *InstallCloudMonitorAgentResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *InstallCloudMonitorAgentResponse
		var err error
		defer close(result)
		response, err = client.InstallCloudMonitorAgent(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// InstallCloudMonitorAgentRequest is the request struct for api InstallCloudMonitorAgent
type InstallCloudMonitorAgentRequest struct {
	*requests.RpcRequest
	ClientToken string           `position:"Query" name:"ClientToken"`
	InstanceId  string           `position:"Query" name:"InstanceId"`
	Force       requests.Boolean `position:"Query" name:"Force"`
}

// InstallCloudMonitorAgentResponse is the response struct for api InstallCloudMonitorAgent
type InstallCloudMonitorAgentResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateInstallCloudMonitorAgentRequest creates a request to invoke InstallCloudMonitorAgent API
func CreateInstallCloudMonitorAgentRequest() (request *InstallCloudMonitorAgentRequest) {
	request = &InstallCloudMonitorAgentRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "InstallCloudMonitorAgent", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateInstallCloudMonitorAgentResponse creates a response to parse from InstallCloudMonitorAgent response
func CreateInstallCloudMonitorAgentResponse() (response *InstallCloudMonitorAgentResponse) {
	response = &InstallCloudMonitorAgentResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
