package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFirewallTemplates invokes the swas_open.DescribeFirewallTemplates API synchronously
func (client *Client) DescribeFirewallTemplates(request *DescribeFirewallTemplatesRequest) (response *DescribeFirewallTemplatesResponse, err error) {
	response = CreateDescribeFirewallTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFirewallTemplatesWithChan invokes the swas_open.DescribeFirewallTemplates API asynchronously
func (client *Client) DescribeFirewallTemplatesWithChan(request *DescribeFirewallTemplatesRequest) (<-chan *DescribeFirewallTemplatesResponse, <-chan error) {
	responseChan := make(chan *DescribeFirewallTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFirewallTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFirewallTemplatesWithCallback invokes the swas_open.DescribeFirewallTemplates API asynchronously
func (client *Client) DescribeFirewallTemplatesWithCallback(request *DescribeFirewallTemplatesRequest, callback func(response *DescribeFirewallTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFirewallTemplatesResponse
		var err error
		defer close(result)
		response, err = client.DescribeFirewallTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFirewallTemplatesRequest is the request struct for api DescribeFirewallTemplates
type DescribeFirewallTemplatesRequest struct {
	*requests.RpcRequest
	FirewallTemplateId *[]string        `position:"Query" name:"FirewallTemplateId"  type:"Repeated"`
	PageNumber         requests.Integer `position:"Query" name:"PageNumber"`
	Name               string           `position:"Query" name:"Name"`
	PageSize           requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeFirewallTemplatesResponse is the response struct for api DescribeFirewallTemplates
type DescribeFirewallTemplatesResponse struct {
	*responses.BaseResponse
	RequestId         string             `json:"RequestId" xml:"RequestId"`
	TotalCount        int                `json:"TotalCount" xml:"TotalCount"`
	PageNumber        int                `json:"PageNumber" xml:"PageNumber"`
	PageSize          int                `json:"PageSize" xml:"PageSize"`
	FirewallTemplates []FirewallTemplate `json:"FirewallTemplates" xml:"FirewallTemplates"`
}

// CreateDescribeFirewallTemplatesRequest creates a request to invoke DescribeFirewallTemplates API
func CreateDescribeFirewallTemplatesRequest() (request *DescribeFirewallTemplatesRequest) {
	request = &DescribeFirewallTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DescribeFirewallTemplates", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeFirewallTemplatesResponse creates a response to parse from DescribeFirewallTemplates response
func CreateDescribeFirewallTemplatesResponse() (response *DescribeFirewallTemplatesResponse) {
	response = &DescribeFirewallTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
