package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteInstanceKeyPair invokes the swas_open.DeleteInstanceKeyPair API synchronously
func (client *Client) DeleteInstanceKeyPair(request *DeleteInstanceKeyPairRequest) (response *DeleteInstanceKeyPairResponse, err error) {
	response = CreateDeleteInstanceKeyPairResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteInstanceKeyPairWithChan invokes the swas_open.DeleteInstanceKeyPair API asynchronously
func (client *Client) DeleteInstanceKeyPairWithChan(request *DeleteInstanceKeyPairRequest) (<-chan *DeleteInstanceKeyPairResponse, <-chan error) {
	responseChan := make(chan *DeleteInstanceKeyPairResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteInstanceKeyPair(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteInstanceKeyPairWithCallback invokes the swas_open.DeleteInstanceKeyPair API asynchronously
func (client *Client) DeleteInstanceKeyPairWithCallback(request *DeleteInstanceKeyPairRequest, callback func(response *DeleteInstanceKeyPairResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteInstanceKeyPairResponse
		var err error
		defer close(result)
		response, err = client.DeleteInstanceKeyPair(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteInstanceKeyPairRequest is the request struct for api DeleteInstanceKeyPair
type DeleteInstanceKeyPairRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	InstanceId  string `position:"Query" name:"InstanceId"`
}

// DeleteInstanceKeyPairResponse is the response struct for api DeleteInstanceKeyPair
type DeleteInstanceKeyPairResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteInstanceKeyPairRequest creates a request to invoke DeleteInstanceKeyPair API
func CreateDeleteInstanceKeyPairRequest() (request *DeleteInstanceKeyPairRequest) {
	request = &DeleteInstanceKeyPairRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "DeleteInstanceKeyPair", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteInstanceKeyPairResponse creates a response to parse from DeleteInstanceKeyPair response
func CreateDeleteInstanceKeyPairResponse() (response *DeleteInstanceKeyPairResponse) {
	response = &DeleteInstanceKeyPairResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
