package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateInstanceKeyPair invokes the swas_open.CreateInstanceKeyPair API synchronously
func (client *Client) CreateInstanceKeyPair(request *CreateInstanceKeyPairRequest) (response *CreateInstanceKeyPairResponse, err error) {
	response = CreateCreateInstanceKeyPairResponse()
	err = client.DoAction(request, response)
	return
}

// CreateInstanceKeyPairWithChan invokes the swas_open.CreateInstanceKeyPair API asynchronously
func (client *Client) CreateInstanceKeyPairWithChan(request *CreateInstanceKeyPairRequest) (<-chan *CreateInstanceKeyPairResponse, <-chan error) {
	responseChan := make(chan *CreateInstanceKeyPairResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateInstanceKeyPair(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateInstanceKeyPairWithCallback invokes the swas_open.CreateInstanceKeyPair API asynchronously
func (client *Client) CreateInstanceKeyPairWithCallback(request *CreateInstanceKeyPairRequest, callback func(response *CreateInstanceKeyPairResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateInstanceKeyPairResponse
		var err error
		defer close(result)
		response, err = client.CreateInstanceKeyPair(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateInstanceKeyPairRequest is the request struct for api CreateInstanceKeyPair
type CreateInstanceKeyPairRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query" name:"ClientToken"`
	KeyPairName string `position:"Query" name:"KeyPairName"`
	InstanceId  string `position:"Query" name:"InstanceId"`
}

// CreateInstanceKeyPairResponse is the response struct for api CreateInstanceKeyPair
type CreateInstanceKeyPairResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	KeyPairName string `json:"KeyPairName" xml:"KeyPairName"`
	Fingerprint string `json:"Fingerprint" xml:"Fingerprint"`
	PrivateKey  string `json:"PrivateKey" xml:"PrivateKey"`
}

// CreateCreateInstanceKeyPairRequest creates a request to invoke CreateInstanceKeyPair API
func CreateCreateInstanceKeyPairRequest() (request *CreateInstanceKeyPairRequest) {
	request = &CreateInstanceKeyPairRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "CreateInstanceKeyPair", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateInstanceKeyPairResponse creates a response to parse from CreateInstanceKeyPair response
func CreateCreateInstanceKeyPairResponse() (response *CreateInstanceKeyPairResponse) {
	response = &CreateInstanceKeyPairResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
