package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TriggerSophonPlaybook invokes the sophonsoar.TriggerSophonPlaybook API synchronously
func (client *Client) TriggerSophonPlaybook(request *TriggerSophonPlaybookRequest) (response *TriggerSophonPlaybookResponse, err error) {
	response = CreateTriggerSophonPlaybookResponse()
	err = client.DoAction(request, response)
	return
}

// TriggerSophonPlaybookWithChan invokes the sophonsoar.TriggerSophonPlaybook API asynchronously
func (client *Client) TriggerSophonPlaybookWithChan(request *TriggerSophonPlaybookRequest) (<-chan *TriggerSophonPlaybookResponse, <-chan error) {
	responseChan := make(chan *TriggerSophonPlaybookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TriggerSophonPlaybook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TriggerSophonPlaybookWithCallback invokes the sophonsoar.TriggerSophonPlaybook API asynchronously
func (client *Client) TriggerSophonPlaybookWithCallback(request *TriggerSophonPlaybookRequest, callback func(response *TriggerSophonPlaybookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TriggerSophonPlaybookResponse
		var err error
		defer close(result)
		response, err = client.TriggerSophonPlaybook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TriggerSophonPlaybookRequest is the request struct for api TriggerSophonPlaybook
type TriggerSophonPlaybookRequest struct {
	*requests.RpcRequest
	RoleFor       string `position:"Query" name:"RoleFor"`
	InputParams   string `position:"Query" name:"InputParams"`
	CommandName   string `position:"Query" name:"CommandName"`
	SophonTaskId  string `position:"Query" name:"SophonTaskId"`
	TriggerType   string `position:"Query" name:"TriggerType"`
	Uuid          string `position:"Query" name:"Uuid"`
	TriggerSource string `position:"Query" name:"TriggerSource"`
	RoleType      string `position:"Query" name:"RoleType"`
	Lang          string `position:"Query" name:"Lang"`
}

// TriggerSophonPlaybookResponse is the response struct for api TriggerSophonPlaybook
type TriggerSophonPlaybookResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateTriggerSophonPlaybookRequest creates a request to invoke TriggerSophonPlaybook API
func CreateTriggerSophonPlaybookRequest() (request *TriggerSophonPlaybookRequest) {
	request = &TriggerSophonPlaybookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "TriggerSophonPlaybook", "", "")
	request.Method = requests.POST
	return
}

// CreateTriggerSophonPlaybookResponse creates a response to parse from TriggerSophonPlaybook response
func CreateTriggerSophonPlaybookResponse() (response *TriggerSophonPlaybookResponse) {
	response = &TriggerSophonPlaybookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
