package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TriggerPlaybook invokes the sophonsoar.TriggerPlaybook API synchronously
func (client *Client) TriggerPlaybook(request *TriggerPlaybookRequest) (response *TriggerPlaybookResponse, err error) {
	response = CreateTriggerPlaybookResponse()
	err = client.DoAction(request, response)
	return
}

// TriggerPlaybookWithChan invokes the sophonsoar.TriggerPlaybook API asynchronously
func (client *Client) TriggerPlaybookWithChan(request *TriggerPlaybookRequest) (<-chan *TriggerPlaybookResponse, <-chan error) {
	responseChan := make(chan *TriggerPlaybookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TriggerPlaybook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TriggerPlaybookWithCallback invokes the sophonsoar.TriggerPlaybook API asynchronously
func (client *Client) TriggerPlaybookWithCallback(request *TriggerPlaybookRequest, callback func(response *TriggerPlaybookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TriggerPlaybookResponse
		var err error
		defer close(result)
		response, err = client.TriggerPlaybook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TriggerPlaybookRequest is the request struct for api TriggerPlaybook
type TriggerPlaybookRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	InputParam   string `position:"Body" name:"InputParam"`
	PlaybookUuid string `position:"Body" name:"PlaybookUuid"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Body" name:"Lang"`
}

// TriggerPlaybookResponse is the response struct for api TriggerPlaybook
type TriggerPlaybookResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	TriggerUuid string `json:"TriggerUuid" xml:"TriggerUuid"`
}

// CreateTriggerPlaybookRequest creates a request to invoke TriggerPlaybook API
func CreateTriggerPlaybookRequest() (request *TriggerPlaybookRequest) {
	request = &TriggerPlaybookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "TriggerPlaybook", "", "")
	request.Method = requests.POST
	return
}

// CreateTriggerPlaybookResponse creates a response to parse from TriggerPlaybook response
func CreateTriggerPlaybookResponse() (response *TriggerPlaybookResponse) {
	response = &TriggerPlaybookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
