package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RenamePlaybookNode invokes the sophonsoar.RenamePlaybookNode API synchronously
func (client *Client) RenamePlaybookNode(request *RenamePlaybookNodeRequest) (response *RenamePlaybookNodeResponse, err error) {
	response = CreateRenamePlaybookNodeResponse()
	err = client.DoAction(request, response)
	return
}

// RenamePlaybookNodeWithChan invokes the sophonsoar.RenamePlaybookNode API asynchronously
func (client *Client) RenamePlaybookNodeWithChan(request *RenamePlaybookNodeRequest) (<-chan *RenamePlaybookNodeResponse, <-chan error) {
	responseChan := make(chan *RenamePlaybookNodeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RenamePlaybookNode(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RenamePlaybookNodeWithCallback invokes the sophonsoar.RenamePlaybookNode API asynchronously
func (client *Client) RenamePlaybookNodeWithCallback(request *RenamePlaybookNodeRequest, callback func(response *RenamePlaybookNodeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RenamePlaybookNodeResponse
		var err error
		defer close(result)
		response, err = client.RenamePlaybookNode(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RenamePlaybookNodeRequest is the request struct for api RenamePlaybookNode
type RenamePlaybookNodeRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	NewNodeName  string `position:"Query" name:"NewNodeName"`
	OldNodeName  string `position:"Query" name:"OldNodeName"`
	PlaybookUuid string `position:"Query" name:"PlaybookUuid"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Query" name:"Lang"`
}

// RenamePlaybookNodeResponse is the response struct for api RenamePlaybookNode
type RenamePlaybookNodeResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	RenameResult string `json:"RenameResult" xml:"RenameResult"`
}

// CreateRenamePlaybookNodeRequest creates a request to invoke RenamePlaybookNode API
func CreateRenamePlaybookNodeRequest() (request *RenamePlaybookNodeRequest) {
	request = &RenamePlaybookNodeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "RenamePlaybookNode", "", "")
	request.Method = requests.POST
	return
}

// CreateRenamePlaybookNodeResponse creates a response to parse from RenamePlaybookNode response
func CreateRenamePlaybookNodeResponse() (response *RenamePlaybookNodeResponse) {
	response = &RenamePlaybookNodeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
