package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePlaybookMetrics invokes the sophonsoar.DescribePlaybookMetrics API synchronously
func (client *Client) DescribePlaybookMetrics(request *DescribePlaybookMetricsRequest) (response *DescribePlaybookMetricsResponse, err error) {
	response = CreateDescribePlaybookMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePlaybookMetricsWithChan invokes the sophonsoar.DescribePlaybookMetrics API asynchronously
func (client *Client) DescribePlaybookMetricsWithChan(request *DescribePlaybookMetricsRequest) (<-chan *DescribePlaybookMetricsResponse, <-chan error) {
	responseChan := make(chan *DescribePlaybookMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePlaybookMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePlaybookMetricsWithCallback invokes the sophonsoar.DescribePlaybookMetrics API asynchronously
func (client *Client) DescribePlaybookMetricsWithCallback(request *DescribePlaybookMetricsRequest, callback func(response *DescribePlaybookMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePlaybookMetricsResponse
		var err error
		defer close(result)
		response, err = client.DescribePlaybookMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePlaybookMetricsRequest is the request struct for api DescribePlaybookMetrics
type DescribePlaybookMetricsRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	PlaybookUuid string `position:"Query" name:"PlaybookUuid"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribePlaybookMetricsResponse is the response struct for api DescribePlaybookMetrics
type DescribePlaybookMetricsResponse struct {
	*responses.BaseResponse
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Metrics   Metrics `json:"Metrics" xml:"Metrics"`
}

// CreateDescribePlaybookMetricsRequest creates a request to invoke DescribePlaybookMetrics API
func CreateDescribePlaybookMetricsRequest() (request *DescribePlaybookMetricsRequest) {
	request = &DescribePlaybookMetricsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribePlaybookMetrics", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribePlaybookMetricsResponse creates a response to parse from DescribePlaybookMetrics response
func CreateDescribePlaybookMetricsResponse() (response *DescribePlaybookMetricsResponse) {
	response = &DescribePlaybookMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
