package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePlaybook invokes the sophonsoar.DescribePlaybook API synchronously
func (client *Client) DescribePlaybook(request *DescribePlaybookRequest) (response *DescribePlaybookResponse, err error) {
	response = CreateDescribePlaybookResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePlaybookWithChan invokes the sophonsoar.DescribePlaybook API asynchronously
func (client *Client) DescribePlaybookWithChan(request *DescribePlaybookRequest) (<-chan *DescribePlaybookResponse, <-chan error) {
	responseChan := make(chan *DescribePlaybookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePlaybook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePlaybookWithCallback invokes the sophonsoar.DescribePlaybook API asynchronously
func (client *Client) DescribePlaybookWithCallback(request *DescribePlaybookRequest, callback func(response *DescribePlaybookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePlaybookResponse
		var err error
		defer close(result)
		response, err = client.DescribePlaybook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePlaybookRequest is the request struct for api DescribePlaybook
type DescribePlaybookRequest struct {
	*requests.RpcRequest
	TaskflowMd5  string           `position:"Query" name:"TaskflowMd5"`
	RoleFor      string           `position:"Query" name:"RoleFor"`
	DebugFlag    requests.Integer `position:"Query" name:"DebugFlag"`
	PlaybookUuid string           `position:"Query" name:"PlaybookUuid"`
	RoleType     string           `position:"Query" name:"RoleType"`
	Lang         string           `position:"Query" name:"Lang"`
}

// DescribePlaybookResponse is the response struct for api DescribePlaybook
type DescribePlaybookResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Playbook  Playbook `json:"Playbook" xml:"Playbook"`
}

// CreateDescribePlaybookRequest creates a request to invoke DescribePlaybook API
func CreateDescribePlaybookRequest() (request *DescribePlaybookRequest) {
	request = &DescribePlaybookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribePlaybook", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribePlaybookResponse creates a response to parse from DescribePlaybook response
func CreateDescribePlaybookResponse() (response *DescribePlaybookResponse) {
	response = &DescribePlaybookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
