package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeComponentsJs invokes the sophonsoar.DescribeComponentsJs API synchronously
func (client *Client) DescribeComponentsJs(request *DescribeComponentsJsRequest) (response *DescribeComponentsJsResponse, err error) {
	response = CreateDescribeComponentsJsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeComponentsJsWithChan invokes the sophonsoar.DescribeComponentsJs API asynchronously
func (client *Client) DescribeComponentsJsWithChan(request *DescribeComponentsJsRequest) (<-chan *DescribeComponentsJsResponse, <-chan error) {
	responseChan := make(chan *DescribeComponentsJsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeComponentsJs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeComponentsJsWithCallback invokes the sophonsoar.DescribeComponentsJs API asynchronously
func (client *Client) DescribeComponentsJsWithCallback(request *DescribeComponentsJsRequest, callback func(response *DescribeComponentsJsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeComponentsJsResponse
		var err error
		defer close(result)
		response, err = client.DescribeComponentsJs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeComponentsJsRequest is the request struct for api DescribeComponentsJs
type DescribeComponentsJsRequest struct {
	*requests.RpcRequest
	RoleFor  string `position:"Query" name:"RoleFor"`
	RoleType string `position:"Query" name:"RoleType"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeComponentsJsResponse is the response struct for api DescribeComponentsJs
type DescribeComponentsJsResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	ComponentsJs string `json:"ComponentsJs" xml:"ComponentsJs"`
}

// CreateDescribeComponentsJsRequest creates a request to invoke DescribeComponentsJs API
func CreateDescribeComponentsJsRequest() (request *DescribeComponentsJsRequest) {
	request = &DescribeComponentsJsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeComponentsJs", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeComponentsJsResponse creates a response to parse from DescribeComponentsJs response
func CreateDescribeComponentsJsResponse() (response *DescribeComponentsJsResponse) {
	response = &DescribeComponentsJsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
