package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConvertPlaybook invokes the sophonsoar.ConvertPlaybook API synchronously
func (client *Client) ConvertPlaybook(request *ConvertPlaybookRequest) (response *ConvertPlaybookResponse, err error) {
	response = CreateConvertPlaybookResponse()
	err = client.DoAction(request, response)
	return
}

// ConvertPlaybookWithChan invokes the sophonsoar.ConvertPlaybook API asynchronously
func (client *Client) ConvertPlaybookWithChan(request *ConvertPlaybookRequest) (<-chan *ConvertPlaybookResponse, <-chan error) {
	responseChan := make(chan *ConvertPlaybookResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConvertPlaybook(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConvertPlaybookWithCallback invokes the sophonsoar.ConvertPlaybook API asynchronously
func (client *Client) ConvertPlaybookWithCallback(request *ConvertPlaybookRequest, callback func(response *ConvertPlaybookResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConvertPlaybookResponse
		var err error
		defer close(result)
		response, err = client.ConvertPlaybook(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConvertPlaybookRequest is the request struct for api ConvertPlaybook
type ConvertPlaybookRequest struct {
	*requests.RpcRequest
	RoleFor  requests.Integer `position:"Query" name:"RoleFor"`
	Taskflow string           `position:"Body" name:"Taskflow"`
	RoleType string           `position:"Query" name:"RoleType"`
	Lang     string           `position:"Query" name:"Lang"`
}

// ConvertPlaybookResponse is the response struct for api ConvertPlaybook
type ConvertPlaybookResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Config    string `json:"Config" xml:"Config"`
}

// CreateConvertPlaybookRequest creates a request to invoke ConvertPlaybook API
func CreateConvertPlaybookRequest() (request *ConvertPlaybookRequest) {
	request = &ConvertPlaybookRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "ConvertPlaybook", "", "")
	request.Method = requests.POST
	return
}

// CreateConvertPlaybookResponse creates a response to parse from ConvertPlaybook response
func CreateConvertPlaybookResponse() (response *ConvertPlaybookResponse) {
	response = &ConvertPlaybookResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
