package sls

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DataExpressionProcess invokes the sls.DataExpressionProcess API synchronously
func (client *Client) DataExpressionProcess(request *DataExpressionProcessRequest) (response *DataExpressionProcessResponse, err error) {
	response = CreateDataExpressionProcessResponse()
	err = client.DoAction(request, response)
	return
}

// DataExpressionProcessWithChan invokes the sls.DataExpressionProcess API asynchronously
func (client *Client) DataExpressionProcessWithChan(request *DataExpressionProcessRequest) (<-chan *DataExpressionProcessResponse, <-chan error) {
	responseChan := make(chan *DataExpressionProcessResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DataExpressionProcess(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DataExpressionProcessWithCallback invokes the sls.DataExpressionProcess API asynchronously
func (client *Client) DataExpressionProcessWithCallback(request *DataExpressionProcessRequest, callback func(response *DataExpressionProcessResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DataExpressionProcessResponse
		var err error
		defer close(result)
		response, err = client.DataExpressionProcess(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DataExpressionProcessRequest is the request struct for api DataExpressionProcess
type DataExpressionProcessRequest struct {
	*requests.RpcRequest
	Method         string `position:"Query" name:"Method"`
	SlsAccessToken string `position:"Query" name:"SlsAccessToken"`
	Detail         string `position:"Query" name:"Detail"`
}

// DataExpressionProcessResponse is the response struct for api DataExpressionProcess
type DataExpressionProcessResponse struct {
	*responses.BaseResponse
}

// CreateDataExpressionProcessRequest creates a request to invoke DataExpressionProcess API
func CreateDataExpressionProcessRequest() (request *DataExpressionProcessRequest) {
	request = &DataExpressionProcessRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sls", "2019-10-23", "DataExpressionProcess", "sls", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDataExpressionProcessResponse creates a response to parse from DataExpressionProcess response
func CreateDataExpressionProcessResponse() (response *DataExpressionProcessResponse) {
	response = &DataExpressionProcessResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
