package sddp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDataObjectColumnDetailV2 invokes the sddp.DescribeDataObjectColumnDetailV2 API synchronously
func (client *Client) DescribeDataObjectColumnDetailV2(request *DescribeDataObjectColumnDetailV2Request) (response *DescribeDataObjectColumnDetailV2Response, err error) {
	response = CreateDescribeDataObjectColumnDetailV2Response()
	err = client.DoAction(request, response)
	return
}

// DescribeDataObjectColumnDetailV2WithChan invokes the sddp.DescribeDataObjectColumnDetailV2 API asynchronously
func (client *Client) DescribeDataObjectColumnDetailV2WithChan(request *DescribeDataObjectColumnDetailV2Request) (<-chan *DescribeDataObjectColumnDetailV2Response, <-chan error) {
	responseChan := make(chan *DescribeDataObjectColumnDetailV2Response, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDataObjectColumnDetailV2(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDataObjectColumnDetailV2WithCallback invokes the sddp.DescribeDataObjectColumnDetailV2 API asynchronously
func (client *Client) DescribeDataObjectColumnDetailV2WithCallback(request *DescribeDataObjectColumnDetailV2Request, callback func(response *DescribeDataObjectColumnDetailV2Response, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDataObjectColumnDetailV2Response
		var err error
		defer close(result)
		response, err = client.DescribeDataObjectColumnDetailV2(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDataObjectColumnDetailV2Request is the request struct for api DescribeDataObjectColumnDetailV2
type DescribeDataObjectColumnDetailV2Request struct {
	*requests.RpcRequest
	ProductId   requests.Integer `position:"Query" name:"ProductId"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Id          string           `position:"Query" name:"Id"`
	Lang        string           `position:"Query" name:"Lang"`
	FeatureType requests.Integer `position:"Query" name:"FeatureType"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	TemplateId  requests.Integer `position:"Query" name:"TemplateId"`
}

// DescribeDataObjectColumnDetailV2Response is the response struct for api DescribeDataObjectColumnDetailV2
type DescribeDataObjectColumnDetailV2Response struct {
	*responses.BaseResponse
	CurrentPage int    `json:"CurrentPage" xml:"CurrentPage"`
	RequestId   string `json:"RequestId" xml:"RequestId"`
	PageSize    int    `json:"PageSize" xml:"PageSize"`
	TotalCount  int    `json:"TotalCount" xml:"TotalCount"`
	Items       []Rule `json:"Items" xml:"Items"`
}

// CreateDescribeDataObjectColumnDetailV2Request creates a request to invoke DescribeDataObjectColumnDetailV2 API
func CreateDescribeDataObjectColumnDetailV2Request() (request *DescribeDataObjectColumnDetailV2Request) {
	request = &DescribeDataObjectColumnDetailV2Request{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sddp", "2019-01-03", "DescribeDataObjectColumnDetailV2", "sddp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDataObjectColumnDetailV2Response creates a response to parse from DescribeDataObjectColumnDetailV2 response
func CreateDescribeDataObjectColumnDetailV2Response() (response *DescribeDataObjectColumnDetailV2Response) {
	response = &DescribeDataObjectColumnDetailV2Response{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
