package schedulerx3

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListExecutors invokes the schedulerx3.ListExecutors API synchronously
func (client *Client) ListExecutors(request *ListExecutorsRequest) (response *ListExecutorsResponse, err error) {
	response = CreateListExecutorsResponse()
	err = client.DoAction(request, response)
	return
}

// ListExecutorsWithChan invokes the schedulerx3.ListExecutors API asynchronously
func (client *Client) ListExecutorsWithChan(request *ListExecutorsRequest) (<-chan *ListExecutorsResponse, <-chan error) {
	responseChan := make(chan *ListExecutorsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListExecutors(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListExecutorsWithCallback invokes the schedulerx3.ListExecutors API asynchronously
func (client *Client) ListExecutorsWithCallback(request *ListExecutorsRequest, callback func(response *ListExecutorsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListExecutorsResponse
		var err error
		defer close(result)
		response, err = client.ListExecutors(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListExecutorsRequest is the request struct for api ListExecutors
type ListExecutorsRequest struct {
	*requests.RpcRequest
	MseSessionId string           `position:"Query" name:"MseSessionId"`
	JobId        requests.Integer `position:"Query" name:"JobId"`
	AppName      string           `position:"Query" name:"AppName"`
	ClusterId    string           `position:"Query" name:"ClusterId"`
	Label        string           `position:"Query" name:"Label"`
}

// ListExecutorsResponse is the response struct for api ListExecutors
type ListExecutorsResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	Success   bool       `json:"Success" xml:"Success"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListExecutorsRequest creates a request to invoke ListExecutors API
func CreateListExecutorsRequest() (request *ListExecutorsRequest) {
	request = &ListExecutorsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SchedulerX3", "2024-06-24", "ListExecutors", "", "")
	request.Method = requests.GET
	return
}

// CreateListExecutorsResponse creates a response to parse from ListExecutors response
func CreateListExecutorsResponse() (response *ListExecutorsResponse) {
	response = &ListExecutorsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
