package scdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyScdnDomainOwner invokes the scdn.VerifyScdnDomainOwner API synchronously
func (client *Client) VerifyScdnDomainOwner(request *VerifyScdnDomainOwnerRequest) (response *VerifyScdnDomainOwnerResponse, err error) {
	response = CreateVerifyScdnDomainOwnerResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyScdnDomainOwnerWithChan invokes the scdn.VerifyScdnDomainOwner API asynchronously
func (client *Client) VerifyScdnDomainOwnerWithChan(request *VerifyScdnDomainOwnerRequest) (<-chan *VerifyScdnDomainOwnerResponse, <-chan error) {
	responseChan := make(chan *VerifyScdnDomainOwnerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyScdnDomainOwner(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyScdnDomainOwnerWithCallback invokes the scdn.VerifyScdnDomainOwner API asynchronously
func (client *Client) VerifyScdnDomainOwnerWithCallback(request *VerifyScdnDomainOwnerRequest, callback func(response *VerifyScdnDomainOwnerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyScdnDomainOwnerResponse
		var err error
		defer close(result)
		response, err = client.VerifyScdnDomainOwner(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyScdnDomainOwnerRequest is the request struct for api VerifyScdnDomainOwner
type VerifyScdnDomainOwnerRequest struct {
	*requests.RpcRequest
	DomainName string `position:"Query" name:"DomainName"`
	VerifyType string `position:"Query" name:"VerifyType"`
}

// VerifyScdnDomainOwnerResponse is the response struct for api VerifyScdnDomainOwner
type VerifyScdnDomainOwnerResponse struct {
	*responses.BaseResponse
	Content   string `json:"Content" xml:"Content"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateVerifyScdnDomainOwnerRequest creates a request to invoke VerifyScdnDomainOwner API
func CreateVerifyScdnDomainOwnerRequest() (request *VerifyScdnDomainOwnerRequest) {
	request = &VerifyScdnDomainOwnerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scdn", "2017-11-15", "VerifyScdnDomainOwner", "", "")
	request.Method = requests.POST
	return
}

// CreateVerifyScdnDomainOwnerResponse creates a response to parse from VerifyScdnDomainOwner response
func CreateVerifyScdnDomainOwnerResponse() (response *VerifyScdnDomainOwnerResponse) {
	response = &VerifyScdnDomainOwnerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
