package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePropertyPortDetail invokes the sas.DescribePropertyPortDetail API synchronously
func (client *Client) DescribePropertyPortDetail(request *DescribePropertyPortDetailRequest) (response *DescribePropertyPortDetailResponse, err error) {
	response = CreateDescribePropertyPortDetailResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePropertyPortDetailWithChan invokes the sas.DescribePropertyPortDetail API asynchronously
func (client *Client) DescribePropertyPortDetailWithChan(request *DescribePropertyPortDetailRequest) (<-chan *DescribePropertyPortDetailResponse, <-chan error) {
	responseChan := make(chan *DescribePropertyPortDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePropertyPortDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePropertyPortDetailWithCallback invokes the sas.DescribePropertyPortDetail API asynchronously
func (client *Client) DescribePropertyPortDetailWithCallback(request *DescribePropertyPortDetailRequest, callback func(response *DescribePropertyPortDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePropertyPortDetailResponse
		var err error
		defer close(result)
		response, err = client.DescribePropertyPortDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePropertyPortDetailRequest is the request struct for api DescribePropertyPortDetail
type DescribePropertyPortDetailRequest struct {
	*requests.RpcRequest
	Remark      string           `position:"Query" name:"Remark"`
	Uuid        string           `position:"Query" name:"Uuid"`
	BindIp      string           `position:"Query" name:"BindIp"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Extend      string           `position:"Query" name:"Extend"`
	Port        string           `position:"Query" name:"Port"`
	ProcName    string           `position:"Query" name:"ProcName"`
}

// DescribePropertyPortDetailResponse is the response struct for api DescribePropertyPortDetail
type DescribePropertyPortDetailResponse struct {
	*responses.BaseResponse
	RequestId string         `json:"RequestId" xml:"RequestId"`
	PageInfo  PageInfo       `json:"PageInfo" xml:"PageInfo"`
	Propertys []PropertyPort `json:"Propertys" xml:"Propertys"`
}

// CreateDescribePropertyPortDetailRequest creates a request to invoke DescribePropertyPortDetail API
func CreateDescribePropertyPortDetailRequest() (request *DescribePropertyPortDetailRequest) {
	request = &DescribePropertyPortDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribePropertyPortDetail", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePropertyPortDetailResponse creates a response to parse from DescribePropertyPortDetail response
func CreateDescribePropertyPortDetailResponse() (response *DescribePropertyPortDetailResponse) {
	response = &DescribePropertyPortDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
