package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBackupRestoreCount invokes the sas.DescribeBackupRestoreCount API synchronously
func (client *Client) DescribeBackupRestoreCount(request *DescribeBackupRestoreCountRequest) (response *DescribeBackupRestoreCountResponse, err error) {
	response = CreateDescribeBackupRestoreCountResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBackupRestoreCountWithChan invokes the sas.DescribeBackupRestoreCount API asynchronously
func (client *Client) DescribeBackupRestoreCountWithChan(request *DescribeBackupRestoreCountRequest) (<-chan *DescribeBackupRestoreCountResponse, <-chan error) {
	responseChan := make(chan *DescribeBackupRestoreCountResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBackupRestoreCount(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBackupRestoreCountWithCallback invokes the sas.DescribeBackupRestoreCount API asynchronously
func (client *Client) DescribeBackupRestoreCountWithCallback(request *DescribeBackupRestoreCountRequest, callback func(response *DescribeBackupRestoreCountResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBackupRestoreCountResponse
		var err error
		defer close(result)
		response, err = client.DescribeBackupRestoreCount(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBackupRestoreCountRequest is the request struct for api DescribeBackupRestoreCount
type DescribeBackupRestoreCountRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
}

// DescribeBackupRestoreCountResponse is the response struct for api DescribeBackupRestoreCount
type DescribeBackupRestoreCountResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	BackupRestoreCount BackupRestoreCount `json:"BackupRestoreCount" xml:"BackupRestoreCount"`
}

// CreateDescribeBackupRestoreCountRequest creates a request to invoke DescribeBackupRestoreCount API
func CreateDescribeBackupRestoreCountRequest() (request *DescribeBackupRestoreCountRequest) {
	request = &DescribeBackupRestoreCountRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeBackupRestoreCount", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBackupRestoreCountResponse creates a response to parse from DescribeBackupRestoreCount response
func CreateDescribeBackupRestoreCountResponse() (response *DescribeBackupRestoreCountResponse) {
	response = &DescribeBackupRestoreCountResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
