package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateHoneypot invokes the sas.CreateHoneypot API synchronously
func (client *Client) CreateHoneypot(request *CreateHoneypotRequest) (response *CreateHoneypotResponse, err error) {
	response = CreateCreateHoneypotResponse()
	err = client.DoAction(request, response)
	return
}

// CreateHoneypotWithChan invokes the sas.CreateHoneypot API asynchronously
func (client *Client) CreateHoneypotWithChan(request *CreateHoneypotRequest) (<-chan *CreateHoneypotResponse, <-chan error) {
	responseChan := make(chan *CreateHoneypotResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateHoneypot(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateHoneypotWithCallback invokes the sas.CreateHoneypot API asynchronously
func (client *Client) CreateHoneypotWithCallback(request *CreateHoneypotRequest, callback func(response *CreateHoneypotResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateHoneypotResponse
		var err error
		defer close(result)
		response, err = client.CreateHoneypot(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateHoneypotRequest is the request struct for api CreateHoneypot
type CreateHoneypotRequest struct {
	*requests.RpcRequest
	HoneypotName      string           `position:"Query" name:"HoneypotName"`
	PageSize          requests.Integer `position:"Query" name:"PageSize"`
	Lang              string           `position:"Query" name:"Lang"`
	NodeId            string           `position:"Query" name:"NodeId"`
	HoneypotImageId   string           `position:"Query" name:"HoneypotImageId"`
	CurrentPage       requests.Integer `position:"Query" name:"CurrentPage"`
	Meta              string           `position:"Query" name:"Meta"`
	HoneypotImageName string           `position:"Query" name:"HoneypotImageName"`
}

// CreateHoneypotResponse is the response struct for api CreateHoneypot
type CreateHoneypotResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateCreateHoneypotRequest creates a request to invoke CreateHoneypot API
func CreateCreateHoneypotRequest() (request *CreateHoneypotRequest) {
	request = &CreateHoneypotRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "CreateHoneypot", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateHoneypotResponse creates a response to parse from CreateHoneypot response
func CreateCreateHoneypotResponse() (response *CreateHoneypotResponse) {
	response = &CreateHoneypotResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
