package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFileDetect invokes the sas.CreateFileDetect API synchronously
func (client *Client) CreateFileDetect(request *CreateFileDetectRequest) (response *CreateFileDetectResponse, err error) {
	response = CreateCreateFileDetectResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFileDetectWithChan invokes the sas.CreateFileDetect API asynchronously
func (client *Client) CreateFileDetectWithChan(request *CreateFileDetectRequest) (<-chan *CreateFileDetectResponse, <-chan error) {
	responseChan := make(chan *CreateFileDetectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFileDetect(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFileDetectWithCallback invokes the sas.CreateFileDetect API asynchronously
func (client *Client) CreateFileDetectWithCallback(request *CreateFileDetectRequest, callback func(response *CreateFileDetectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFileDetectResponse
		var err error
		defer close(result)
		response, err = client.CreateFileDetect(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFileDetectRequest is the request struct for api CreateFileDetect
type CreateFileDetectRequest struct {
	*requests.RpcRequest
	HashKey  string           `position:"Query" name:"HashKey"`
	OssKey   string           `position:"Query" name:"OssKey"`
	Type     requests.Integer `position:"Query" name:"Type"`
	SourceIp string           `position:"Query" name:"SourceIp"`
}

// CreateFileDetectResponse is the response struct for api CreateFileDetect
type CreateFileDetectResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	HashKey   string `json:"HashKey" xml:"HashKey"`
}

// CreateCreateFileDetectRequest creates a request to invoke CreateFileDetect API
func CreateCreateFileDetectRequest() (request *CreateFileDetectRequest) {
	request = &CreateFileDetectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "CreateFileDetect", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateFileDetectResponse creates a response to parse from CreateFileDetect response
func CreateCreateFileDetectResponse() (response *CreateFileDetectResponse) {
	response = &CreateFileDetectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
