package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateBlock invokes the safe.CreateBlock API synchronously
func (client *Client) CreateBlock(request *CreateBlockRequest) (response *CreateBlockResponse, err error) {
	response = CreateCreateBlockResponse()
	err = client.DoAction(request, response)
	return
}

// CreateBlockWithChan invokes the safe.CreateBlock API asynchronously
func (client *Client) CreateBlockWithChan(request *CreateBlockRequest) (<-chan *CreateBlockResponse, <-chan error) {
	responseChan := make(chan *CreateBlockResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateBlock(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateBlockWithCallback invokes the safe.CreateBlock API asynchronously
func (client *Client) CreateBlockWithCallback(request *CreateBlockRequest, callback func(response *CreateBlockResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateBlockResponse
		var err error
		defer close(result)
		response, err = client.CreateBlock(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateBlockRequest is the request struct for api CreateBlock
type CreateBlockRequest struct {
	*requests.RpcRequest
	Reason               string                             `position:"Body" name:"Reason"`
	ApproveStrategyNodes *[]CreateBlockApproveStrategyNodes `position:"Body" name:"ApproveStrategyNodes"  type:"Repeated"`
	Director             string                             `position:"Body" name:"Director"`
	NoticeRequestLink    string                             `position:"Body" name:"NoticeRequestLink"`
	NoticeEnclosureInfos *[]CreateBlockNoticeEnclosureInfos `position:"Body" name:"NoticeEnclosureInfos"  type:"Repeated"`
	Title                string                             `position:"Body" name:"Title"`
	Type                 string                             `position:"Body" name:"Type"`
	LabelName            string                             `position:"Body" name:"LabelName"`
	Scene                requests.Integer                   `position:"Body" name:"Scene"`
	BlockId              requests.Integer                   `position:"Body" name:"BlockId"`
	VersionId            requests.Integer                   `position:"Body" name:"VersionId"`
	IsNeedApprove        requests.Integer                   `position:"Body" name:"IsNeedApprove"`
	NoticeType           requests.Integer                   `position:"Body" name:"NoticeType"`
	IsRecall             requests.Integer                   `position:"Body" name:"IsRecall"`
	NoticeDesc           string                             `position:"Body" name:"NoticeDesc"`
	Scopes               *[]CreateBlockScopes               `position:"Body" name:"Scopes"  type:"Repeated"`
	IsTemplate           requests.Integer                   `position:"Body" name:"IsTemplate"`
	Status               requests.Integer                   `position:"Body" name:"Status"`
}

// CreateBlockApproveStrategyNodes is a repeated param struct in CreateBlockRequest
type CreateBlockApproveStrategyNodes struct {
	RoleCode        string    `name:"RoleCode"`
	ApproveType     string    `name:"ApproveType"`
	Name            string    `name:"Name"`
	NodeCode        string    `name:"NodeCode"`
	RoleValue       *[]string `name:"RoleValue" type:"Repeated"`
	Id              string    `name:"Id"`
	TemplateId      string    `name:"TemplateId"`
	PriorityOrder   string    `name:"PriorityOrder"`
	ApproveRuleType string    `name:"ApproveRuleType"`
}

// CreateBlockNoticeEnclosureInfos is a repeated param struct in CreateBlockRequest
type CreateBlockNoticeEnclosureInfos struct {
	Name string `name:"Name"`
	Url  string `name:"url"`
}

// CreateBlockScopes is a repeated param struct in CreateBlockRequest
type CreateBlockScopes struct {
	BlockScope CreateBlockScopesBlockScope `name:"BlockScope" type:"Struct"`
	BlockHarm  *[]string                   `name:"BlockHarm" type:"Repeated"`
	ScopeRule  string                      `name:"ScopeRule"`
	EffectTime *[]string                   `name:"EffectTime" type:"Repeated"`
}

// CreateBlockScopesBlockScope is a repeated param struct in CreateBlockRequest
type CreateBlockScopesBlockScope struct {
	App            CreateBlockScopesBlockScopeApp             `name:"App" type:"Struct"`
	Cluster        CreateBlockScopesBlockScopeCluster         `name:"Cluster" type:"Struct"`
	Product        *[]CreateBlockScopesBlockScopeProductItem  `name:"Product" type:"Repeated"`
	BgSystem       *[]CreateBlockScopesBlockScopeBgSystemItem `name:"BgSystem" type:"Repeated"`
	Infrastructure *[]string                                  `name:"Infrastructure" type:"Repeated"`
	Express        string                                     `name:"Express"`
	Dept           *[]string                                  `name:"Dept" type:"Repeated"`
	Customer       *[]CreateBlockScopesBlockScopeCustomerItem `name:"Customer" type:"Repeated"`
}

// CreateBlockScopesBlockScopeApp is a repeated param struct in CreateBlockRequest
type CreateBlockScopesBlockScopeApp struct {
	AppName *[]string `name:"AppName" type:"Repeated"`
	Type    string    `name:"Type"`
}

// CreateBlockScopesBlockScopeCluster is a repeated param struct in CreateBlockRequest
type CreateBlockScopesBlockScopeCluster struct {
	CodeNames *[]string                                          `name:"CodeNames" type:"Repeated"`
	Relations *[]CreateBlockScopesBlockScopeClusterRelationsItem `name:"Relations" type:"Repeated"`
}

// CreateBlockScopesBlockScopeProductItem is a repeated param struct in CreateBlockRequest
type CreateBlockScopesBlockScopeProductItem struct {
	CodeNames *[]string                                              `name:"CodeNames" type:"Repeated"`
	ViewCode  *[]string                                              `name:"ViewCode" type:"Repeated"`
	Relations *[]CreateBlockScopesBlockScopeProductItemRelationsItem `name:"Relations" type:"Repeated"`
	Key       string                                                 `name:"Key"`
}

// CreateBlockScopesBlockScopeBgSystemItem is a repeated param struct in CreateBlockRequest
type CreateBlockScopesBlockScopeBgSystemItem struct {
	SelfCodeName string    `name:"SelfCodeName"`
	RelateCodes  *[]string `name:"RelateCodes" type:"Repeated"`
}

// CreateBlockScopesBlockScopeCustomerItem is a repeated param struct in CreateBlockRequest
type CreateBlockScopesBlockScopeCustomerItem struct {
	Uid       string                                                  `name:"Uid"`
	ViewCodes *[]string                                               `name:"ViewCodes" type:"Repeated"`
	CodeNames *[]string                                               `name:"CodeNames" type:"Repeated"`
	Relations *[]CreateBlockScopesBlockScopeCustomerItemRelationsItem `name:"Relations" type:"Repeated"`
}

// CreateBlockScopesBlockScopeClusterRelationsItem is a repeated param struct in CreateBlockRequest
type CreateBlockScopesBlockScopeClusterRelationsItem struct {
	AppCodes    *[]string `name:"AppCodes" type:"Repeated"`
	LabelCodes  *[]string `name:"LabelCodes" type:"Repeated"`
	RelateCodes *[]string `name:"RelateCodes" type:"Repeated"`
	SelfCode    string    `name:"SelfCode"`
}

// CreateBlockScopesBlockScopeProductItemRelationsItem is a repeated param struct in CreateBlockRequest
type CreateBlockScopesBlockScopeProductItemRelationsItem struct {
	AppCodes    *[]string `name:"AppCodes" type:"Repeated"`
	LabelCodes  *[]string `name:"LabelCodes" type:"Repeated"`
	RelateCodes *[]string `name:"RelateCodes" type:"Repeated"`
	SelfCode    string    `name:"SelfCode"`
}

// CreateBlockScopesBlockScopeCustomerItemRelationsItem is a repeated param struct in CreateBlockRequest
type CreateBlockScopesBlockScopeCustomerItemRelationsItem struct {
	AppCodes    *[]string `name:"AppCodes" type:"Repeated"`
	LabelCodes  *[]string `name:"LabelCodes" type:"Repeated"`
	RelateCodes *[]string `name:"RelateCodes" type:"Repeated"`
	SelfCode    string    `name:"SelfCode"`
}

// CreateBlockResponse is the response struct for api CreateBlock
type CreateBlockResponse struct {
	*responses.BaseResponse
	Data      int64  `json:"Data" xml:"Data"`
	Success   bool   `json:"Success" xml:"Success"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateBlockRequest creates a request to invoke CreateBlock API
func CreateCreateBlockRequest() (request *CreateBlockRequest) {
	request = &CreateBlockRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "CreateBlock", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateBlockResponse creates a response to parse from CreateBlock response
func CreateCreateBlockResponse() (response *CreateBlockResponse) {
	response = &CreateBlockResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
