package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ChangeStart invokes the safe.ChangeStart API synchronously
func (client *Client) ChangeStart(request *ChangeStartRequest) (response *ChangeStartResponse, err error) {
	response = CreateChangeStartResponse()
	err = client.DoAction(request, response)
	return
}

// ChangeStartWithChan invokes the safe.ChangeStart API asynchronously
func (client *Client) ChangeStartWithChan(request *ChangeStartRequest) (<-chan *ChangeStartResponse, <-chan error) {
	responseChan := make(chan *ChangeStartResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ChangeStart(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ChangeStartWithCallback invokes the safe.ChangeStart API asynchronously
func (client *Client) ChangeStartWithCallback(request *ChangeStartRequest, callback func(response *ChangeStartResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ChangeStartResponse
		var err error
		defer close(result)
		response, err = client.ChangeStart(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ChangeStartRequest is the request struct for api ChangeStart
type ChangeStartRequest struct {
	*requests.RpcRequest
	AuthKey         string           `position:"Query" name:"AuthKey"`
	TotalBatchNo    requests.Integer `position:"Query" name:"TotalBatchNo"`
	ChangeOptType   string           `position:"Query" name:"ChangeOptType"`
	ChangeObject    string           `position:"Query" name:"ChangeObject"`
	AuthSign        string           `position:"Query" name:"AuthSign"`
	ChangeTitle     string           `position:"Query" name:"ChangeTitle"`
	CreatorEmpId    string           `position:"Query" name:"CreatorEmpId"`
	ChangeStartTime requests.Integer `position:"Query" name:"ChangeStartTime"`
	ReqTimestamp    requests.Integer `position:"Query" name:"ReqTimestamp"`
	ChangeEndTime   requests.Integer `position:"Query" name:"ChangeEndTime"`
	ExecutorEmpId   string           `position:"Query" name:"ExecutorEmpId"`
	CurBatchNo      requests.Integer `position:"Query" name:"CurBatchNo"`
	SourceOrderId   string           `position:"Query" name:"SourceOrderId"`
}

// ChangeStartResponse is the response struct for api ChangeStart
type ChangeStartResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
	Code      int    `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateChangeStartRequest creates a request to invoke ChangeStart API
func CreateChangeStartRequest() (request *ChangeStartRequest) {
	request = &ChangeStartRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "ChangeStart", "", "")
	request.Method = requests.POST
	return
}

// CreateChangeStartResponse creates a response to parse from ChangeStart response
func CreateChangeStartResponse() (response *ChangeStartResponse) {
	response = &ChangeStartResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
