package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExecJob invokes the sae.ExecJob API synchronously
func (client *Client) ExecJob(request *ExecJobRequest) (response *ExecJobResponse, err error) {
	response = CreateExecJobResponse()
	err = client.DoAction(request, response)
	return
}

// ExecJobWithChan invokes the sae.ExecJob API asynchronously
func (client *Client) ExecJobWithChan(request *ExecJobRequest) (<-chan *ExecJobResponse, <-chan error) {
	responseChan := make(chan *ExecJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExecJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExecJobWithCallback invokes the sae.ExecJob API asynchronously
func (client *Client) ExecJobWithCallback(request *ExecJobRequest, callback func(response *ExecJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExecJobResponse
		var err error
		defer close(result)
		response, err = client.ExecJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExecJobRequest is the request struct for api ExecJob
type ExecJobRequest struct {
	*requests.RoaRequest
	EventId         string `position:"Query" name:"EventId"`
	JarStartOptions string `position:"Query" name:"JarStartOptions"`
	JarStartArgs    string `position:"Query" name:"JarStartArgs"`
	CommandArgs     string `position:"Query" name:"CommandArgs"`
	Replicas        string `position:"Query" name:"Replicas"`
	AppId           string `position:"Query" name:"AppId"`
	Envs            string `position:"Query" name:"Envs"`
	Time            string `position:"Query" name:"Time"`
	Command         string `position:"Query" name:"Command"`
	WarStartOptions string `position:"Query" name:"WarStartOptions"`
}

// ExecJobResponse is the response struct for api ExecJob
type ExecJobResponse struct {
	*responses.BaseResponse
	RequestId string        `json:"RequestId" xml:"RequestId"`
	Message   string        `json:"Message" xml:"Message"`
	TraceId   string        `json:"TraceId" xml:"TraceId"`
	ErrorCode string        `json:"ErrorCode" xml:"ErrorCode"`
	Code      string        `json:"Code" xml:"Code"`
	Success   bool          `json:"Success" xml:"Success"`
	Data      DataInExecJob `json:"Data" xml:"Data"`
}

// CreateExecJobRequest creates a request to invoke ExecJob API
func CreateExecJobRequest() (request *ExecJobRequest) {
	request = &ExecJobRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "ExecJob", "/pop/v1/sam/job/execJob", "serverless", "openAPI")
	request.Method = requests.GET
	return
}

// CreateExecJobResponse creates a response to parse from ExecJob response
func CreateExecJobResponse() (response *ExecJobResponse) {
	response = &ExecJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
