package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveLabelDataSet invokes the retailadvqa_public.SaveLabelDataSet API synchronously
func (client *Client) SaveLabelDataSet(request *SaveLabelDataSetRequest) (response *SaveLabelDataSetResponse, err error) {
	response = CreateSaveLabelDataSetResponse()
	err = client.DoAction(request, response)
	return
}

// SaveLabelDataSetWithChan invokes the retailadvqa_public.SaveLabelDataSet API asynchronously
func (client *Client) SaveLabelDataSetWithChan(request *SaveLabelDataSetRequest) (<-chan *SaveLabelDataSetResponse, <-chan error) {
	responseChan := make(chan *SaveLabelDataSetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveLabelDataSet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveLabelDataSetWithCallback invokes the retailadvqa_public.SaveLabelDataSet API asynchronously
func (client *Client) SaveLabelDataSetWithCallback(request *SaveLabelDataSetRequest, callback func(response *SaveLabelDataSetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveLabelDataSetResponse
		var err error
		defer close(result)
		response, err = client.SaveLabelDataSet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveLabelDataSetRequest is the request struct for api SaveLabelDataSet
type SaveLabelDataSetRequest struct {
	*requests.RpcRequest
	AccessId         string                              `position:"Query" name:"AccessId"`
	DsId             string                              `position:"Query" name:"DsId"`
	DatasetLabelList *[]SaveLabelDataSetDatasetLabelList `position:"Query" name:"DatasetLabelList"  type:"Repeated"`
	CubeName         string                              `position:"Query" name:"CubeName"`
	TableName        string                              `position:"Query" name:"TableName"`
	CubeId           string                              `position:"Query" name:"CubeId"`
	WorkspaceId      string                              `position:"Query" name:"WorkspaceId"`
}

// SaveLabelDataSetDatasetLabelList is a repeated param struct in SaveLabelDataSetRequest
type SaveLabelDataSetDatasetLabelList struct {
	ColumnComment        string `name:"ColumnComment"`
	MappingType          string `name:"MappingType"`
	UniqueIdentification string `name:"UniqueIdentification"`
	Remark               string `name:"Remark"`
	ColumnName           string `name:"ColumnName"`
	ColumnType           string `name:"ColumnType"`
}

// SaveLabelDataSetResponse is the response struct for api SaveLabelDataSet
type SaveLabelDataSetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   string `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateSaveLabelDataSetRequest creates a request to invoke SaveLabelDataSet API
func CreateSaveLabelDataSetRequest() (request *SaveLabelDataSetRequest) {
	request = &SaveLabelDataSetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "SaveLabelDataSet", "", "")
	request.Method = requests.POST
	return
}

// CreateSaveLabelDataSetResponse creates a response to parse from SaveLabelDataSet response
func CreateSaveLabelDataSetResponse() (response *SaveLabelDataSetResponse) {
	response = &SaveLabelDataSetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
