package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RecieveEventMessage invokes the retailadvqa_public.RecieveEventMessage API synchronously
func (client *Client) RecieveEventMessage(request *RecieveEventMessageRequest) (response *RecieveEventMessageResponse, err error) {
	response = CreateRecieveEventMessageResponse()
	err = client.DoAction(request, response)
	return
}

// RecieveEventMessageWithChan invokes the retailadvqa_public.RecieveEventMessage API asynchronously
func (client *Client) RecieveEventMessageWithChan(request *RecieveEventMessageRequest) (<-chan *RecieveEventMessageResponse, <-chan error) {
	responseChan := make(chan *RecieveEventMessageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RecieveEventMessage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RecieveEventMessageWithCallback invokes the retailadvqa_public.RecieveEventMessage API asynchronously
func (client *Client) RecieveEventMessageWithCallback(request *RecieveEventMessageRequest, callback func(response *RecieveEventMessageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RecieveEventMessageResponse
		var err error
		defer close(result)
		response, err = client.RecieveEventMessage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RecieveEventMessageRequest is the request struct for api RecieveEventMessage
type RecieveEventMessageRequest struct {
	*requests.RpcRequest
	OrganizationId           string `position:"Query" name:"OrganizationId"`
	AccessId                 string `position:"Query" name:"AccessId"`
	EventMessageModelListStr string `position:"Body" name:"EventMessageModelListStr"`
}

// RecieveEventMessageResponse is the response struct for api RecieveEventMessage
type RecieveEventMessageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateRecieveEventMessageRequest creates a request to invoke RecieveEventMessage API
func CreateRecieveEventMessageRequest() (request *RecieveEventMessageRequest) {
	request = &RecieveEventMessageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "RecieveEventMessage", "", "")
	request.Method = requests.POST
	return
}

// CreateRecieveEventMessageResponse creates a response to parse from RecieveEventMessage response
func CreateRecieveEventMessageResponse() (response *RecieveEventMessageResponse) {
	response = &RecieveEventMessageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
