package retailadvqa_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTemplates invokes the retailadvqa_public.DeleteTemplates API synchronously
func (client *Client) DeleteTemplates(request *DeleteTemplatesRequest) (response *DeleteTemplatesResponse, err error) {
	response = CreateDeleteTemplatesResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTemplatesWithChan invokes the retailadvqa_public.DeleteTemplates API asynchronously
func (client *Client) DeleteTemplatesWithChan(request *DeleteTemplatesRequest) (<-chan *DeleteTemplatesResponse, <-chan error) {
	responseChan := make(chan *DeleteTemplatesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTemplates(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTemplatesWithCallback invokes the retailadvqa_public.DeleteTemplates API asynchronously
func (client *Client) DeleteTemplatesWithCallback(request *DeleteTemplatesRequest, callback func(response *DeleteTemplatesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTemplatesResponse
		var err error
		defer close(result)
		response, err = client.DeleteTemplates(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTemplatesRequest is the request struct for api DeleteTemplates
type DeleteTemplatesRequest struct {
	*requests.RpcRequest
	AccessId    string `position:"Query" name:"AccessId"`
	TenantId    string `position:"Query" name:"TenantId"`
	Comefrom    string `position:"Query" name:"Comefrom"`
	Id          string `position:"Query" name:"Id"`
	WorkspaceId string `position:"Query" name:"WorkspaceId"`
}

// DeleteTemplatesResponse is the response struct for api DeleteTemplates
type DeleteTemplatesResponse struct {
	*responses.BaseResponse
	Data      int64  `json:"Data" xml:"Data"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorDesc string `json:"ErrorDesc" xml:"ErrorDesc"`
	Success   bool   `json:"Success" xml:"Success"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	ExStack   string `json:"ExStack" xml:"ExStack"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTemplatesRequest creates a request to invoke DeleteTemplates API
func CreateDeleteTemplatesRequest() (request *DeleteTemplatesRequest) {
	request = &DeleteTemplatesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("retailadvqa-public", "2020-05-15", "DeleteTemplates", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteTemplatesResponse creates a response to parse from DeleteTemplates response
func CreateDeleteTemplatesResponse() (response *DeleteTemplatesResponse) {
	response = &DeleteTemplatesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
