package resourcesharing

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourceShares invokes the resourcesharing.ListResourceShares API synchronously
func (client *Client) ListResourceShares(request *ListResourceSharesRequest) (response *ListResourceSharesResponse, err error) {
	response = CreateListResourceSharesResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourceSharesWithChan invokes the resourcesharing.ListResourceShares API asynchronously
func (client *Client) ListResourceSharesWithChan(request *ListResourceSharesRequest) (<-chan *ListResourceSharesResponse, <-chan error) {
	responseChan := make(chan *ListResourceSharesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourceShares(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourceSharesWithCallback invokes the resourcesharing.ListResourceShares API asynchronously
func (client *Client) ListResourceSharesWithCallback(request *ListResourceSharesRequest, callback func(response *ListResourceSharesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourceSharesResponse
		var err error
		defer close(result)
		response, err = client.ListResourceShares(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourceSharesRequest is the request struct for api ListResourceShares
type ListResourceSharesRequest struct {
	*requests.RpcRequest
	ResourceShareName   string           `position:"Query" name:"ResourceShareName"`
	PermissionName      string           `position:"Query" name:"PermissionName"`
	ResourceGroupId     string           `position:"Query" name:"ResourceGroupId"`
	NextToken           string           `position:"Query" name:"NextToken"`
	ResourceShareIds    *[]string        `position:"Query" name:"ResourceShareIds"  type:"Repeated"`
	ResourceOwner       string           `position:"Query" name:"ResourceOwner"`
	ResourceShareStatus string           `position:"Query" name:"ResourceShareStatus"`
	MaxResults          requests.Integer `position:"Query" name:"MaxResults"`
}

// ListResourceSharesResponse is the response struct for api ListResourceShares
type ListResourceSharesResponse struct {
	*responses.BaseResponse
	NextToken      string          `json:"NextToken" xml:"NextToken"`
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	ResourceShares []ResourceShare `json:"ResourceShares" xml:"ResourceShares"`
}

// CreateListResourceSharesRequest creates a request to invoke ListResourceShares API
func CreateListResourceSharesRequest() (request *ListResourceSharesRequest) {
	request = &ListResourceSharesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceSharing", "2020-01-10", "ListResourceShares", "ressharing", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListResourceSharesResponse creates a response to parse from ListResourceShares response
func CreateListResourceSharesResponse() (response *ListResourceSharesResponse) {
	response = &ListResourceSharesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
