package resourcemanager

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAssociatedTransferSetting invokes the resourcemanager.ListAssociatedTransferSetting API synchronously
func (client *Client) ListAssociatedTransferSetting(request *ListAssociatedTransferSettingRequest) (response *ListAssociatedTransferSettingResponse, err error) {
	response = CreateListAssociatedTransferSettingResponse()
	err = client.DoAction(request, response)
	return
}

// ListAssociatedTransferSettingWithChan invokes the resourcemanager.ListAssociatedTransferSetting API asynchronously
func (client *Client) ListAssociatedTransferSettingWithChan(request *ListAssociatedTransferSettingRequest) (<-chan *ListAssociatedTransferSettingResponse, <-chan error) {
	responseChan := make(chan *ListAssociatedTransferSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAssociatedTransferSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAssociatedTransferSettingWithCallback invokes the resourcemanager.ListAssociatedTransferSetting API asynchronously
func (client *Client) ListAssociatedTransferSettingWithCallback(request *ListAssociatedTransferSettingRequest, callback func(response *ListAssociatedTransferSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAssociatedTransferSettingResponse
		var err error
		defer close(result)
		response, err = client.ListAssociatedTransferSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAssociatedTransferSettingRequest is the request struct for api ListAssociatedTransferSetting
type ListAssociatedTransferSettingRequest struct {
	*requests.RpcRequest
}

// ListAssociatedTransferSettingResponse is the response struct for api ListAssociatedTransferSetting
type ListAssociatedTransferSettingResponse struct {
	*responses.BaseResponse
	RequestId                 string                    `json:"RequestId" xml:"RequestId"`
	AssociatedTransferSetting AssociatedTransferSetting `json:"AssociatedTransferSetting" xml:"AssociatedTransferSetting"`
}

// CreateListAssociatedTransferSettingRequest creates a request to invoke ListAssociatedTransferSetting API
func CreateListAssociatedTransferSettingRequest() (request *ListAssociatedTransferSettingRequest) {
	request = &ListAssociatedTransferSettingRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ResourceManager", "2020-03-31", "ListAssociatedTransferSetting", "resourcemanager", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAssociatedTransferSettingResponse creates a response to parse from ListAssociatedTransferSetting response
func CreateListAssociatedTransferSettingResponse() (response *ListAssociatedTransferSettingResponse) {
	response = &ListAssociatedTransferSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
