package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeGadInstances invokes the rds.DescribeGadInstances API synchronously
func (client *Client) DescribeGadInstances(request *DescribeGadInstancesRequest) (response *DescribeGadInstancesResponse, err error) {
	response = CreateDescribeGadInstancesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeGadInstancesWithChan invokes the rds.DescribeGadInstances API asynchronously
func (client *Client) DescribeGadInstancesWithChan(request *DescribeGadInstancesRequest) (<-chan *DescribeGadInstancesResponse, <-chan error) {
	responseChan := make(chan *DescribeGadInstancesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeGadInstances(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeGadInstancesWithCallback invokes the rds.DescribeGadInstances API asynchronously
func (client *Client) DescribeGadInstancesWithCallback(request *DescribeGadInstancesRequest, callback func(response *DescribeGadInstancesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeGadInstancesResponse
		var err error
		defer close(result)
		response, err = client.DescribeGadInstances(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeGadInstancesRequest is the request struct for api DescribeGadInstances
type DescribeGadInstancesRequest struct {
	*requests.RpcRequest
	ResourceGroupId string `position:"Query" name:"ResourceGroupId"`
	GadInstanceName string `position:"Query" name:"GadInstanceName"`
}

// DescribeGadInstancesResponse is the response struct for api DescribeGadInstances
type DescribeGadInstancesResponse struct {
	*responses.BaseResponse
	RequestId    string             `json:"RequestId" xml:"RequestId"`
	GadInstances []GadInstancesItem `json:"GadInstances" xml:"GadInstances"`
}

// CreateDescribeGadInstancesRequest creates a request to invoke DescribeGadInstances API
func CreateDescribeGadInstancesRequest() (request *DescribeGadInstancesRequest) {
	request = &DescribeGadInstancesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeGadInstances", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeGadInstancesResponse creates a response to parse from DescribeGadInstances response
func CreateDescribeGadInstancesResponse() (response *DescribeGadInstancesResponse) {
	response = &DescribeGadInstancesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
