package rds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCurrentModifyOrder invokes the rds.DescribeCurrentModifyOrder API synchronously
func (client *Client) DescribeCurrentModifyOrder(request *DescribeCurrentModifyOrderRequest) (response *DescribeCurrentModifyOrderResponse, err error) {
	response = CreateDescribeCurrentModifyOrderResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCurrentModifyOrderWithChan invokes the rds.DescribeCurrentModifyOrder API asynchronously
func (client *Client) DescribeCurrentModifyOrderWithChan(request *DescribeCurrentModifyOrderRequest) (<-chan *DescribeCurrentModifyOrderResponse, <-chan error) {
	responseChan := make(chan *DescribeCurrentModifyOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCurrentModifyOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCurrentModifyOrderWithCallback invokes the rds.DescribeCurrentModifyOrder API asynchronously
func (client *Client) DescribeCurrentModifyOrderWithCallback(request *DescribeCurrentModifyOrderRequest, callback func(response *DescribeCurrentModifyOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCurrentModifyOrderResponse
		var err error
		defer close(result)
		response, err = client.DescribeCurrentModifyOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCurrentModifyOrderRequest is the request struct for api DescribeCurrentModifyOrder
type DescribeCurrentModifyOrderRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	DbInstanceId         string           `position:"Query" name:"DbInstanceId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeCurrentModifyOrderResponse is the response struct for api DescribeCurrentModifyOrder
type DescribeCurrentModifyOrderResponse struct {
	*responses.BaseResponse
	RequestId   string            `json:"RequestId" xml:"RequestId"`
	ModifyOrder []ModifyOrderItem `json:"ModifyOrder" xml:"ModifyOrder"`
}

// CreateDescribeCurrentModifyOrderRequest creates a request to invoke DescribeCurrentModifyOrder API
func CreateDescribeCurrentModifyOrderRequest() (request *DescribeCurrentModifyOrderRequest) {
	request = &DescribeCurrentModifyOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Rds", "2014-08-15", "DescribeCurrentModifyOrder", "rds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCurrentModifyOrderResponse creates a response to parse from DescribeCurrentModifyOrder response
func CreateDescribeCurrentModifyOrderResponse() (response *DescribeCurrentModifyOrderResponse) {
	response = &DescribeCurrentModifyOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
