package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SmartqAuthTransfer invokes the quickbi_public.SmartqAuthTransfer API synchronously
func (client *Client) SmartqAuthTransfer(request *SmartqAuthTransferRequest) (response *SmartqAuthTransferResponse, err error) {
	response = CreateSmartqAuthTransferResponse()
	err = client.DoAction(request, response)
	return
}

// SmartqAuthTransferWithChan invokes the quickbi_public.SmartqAuthTransfer API asynchronously
func (client *Client) SmartqAuthTransferWithChan(request *SmartqAuthTransferRequest) (<-chan *SmartqAuthTransferResponse, <-chan error) {
	responseChan := make(chan *SmartqAuthTransferResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SmartqAuthTransfer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SmartqAuthTransferWithCallback invokes the quickbi_public.SmartqAuthTransfer API asynchronously
func (client *Client) SmartqAuthTransferWithCallback(request *SmartqAuthTransferRequest, callback func(response *SmartqAuthTransferResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SmartqAuthTransferResponse
		var err error
		defer close(result)
		response, err = client.SmartqAuthTransfer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SmartqAuthTransferRequest is the request struct for api SmartqAuthTransfer
type SmartqAuthTransferRequest struct {
	*requests.RpcRequest
	AccessPoint   string `position:"Query" name:"AccessPoint"`
	TargetUserIds string `position:"Query" name:"TargetUserIds"`
	SignType      string `position:"Query" name:"SignType"`
	OriginUserId  string `position:"Query" name:"OriginUserId"`
}

// SmartqAuthTransferResponse is the response struct for api SmartqAuthTransfer
type SmartqAuthTransferResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateSmartqAuthTransferRequest creates a request to invoke SmartqAuthTransfer API
func CreateSmartqAuthTransferRequest() (request *SmartqAuthTransferRequest) {
	request = &SmartqAuthTransferRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "SmartqAuthTransfer", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSmartqAuthTransferResponse creates a response to parse from SmartqAuthTransfer response
func CreateSmartqAuthTransferResponse() (response *SmartqAuthTransferResponse) {
	response = &SmartqAuthTransferResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
