package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ManualRunMailTask invokes the quickbi_public.ManualRunMailTask API synchronously
func (client *Client) ManualRunMailTask(request *ManualRunMailTaskRequest) (response *ManualRunMailTaskResponse, err error) {
	response = CreateManualRunMailTaskResponse()
	err = client.DoAction(request, response)
	return
}

// ManualRunMailTaskWithChan invokes the quickbi_public.ManualRunMailTask API asynchronously
func (client *Client) ManualRunMailTaskWithChan(request *ManualRunMailTaskRequest) (<-chan *ManualRunMailTaskResponse, <-chan error) {
	responseChan := make(chan *ManualRunMailTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ManualRunMailTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ManualRunMailTaskWithCallback invokes the quickbi_public.ManualRunMailTask API asynchronously
func (client *Client) ManualRunMailTaskWithCallback(request *ManualRunMailTaskRequest, callback func(response *ManualRunMailTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ManualRunMailTaskResponse
		var err error
		defer close(result)
		response, err = client.ManualRunMailTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ManualRunMailTaskRequest is the request struct for api ManualRunMailTask
type ManualRunMailTaskRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	MailId      string `position:"Query" name:"MailId"`
}

// ManualRunMailTaskResponse is the response struct for api ManualRunMailTask
type ManualRunMailTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    bool   `json:"Result" xml:"Result"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateManualRunMailTaskRequest creates a request to invoke ManualRunMailTask API
func CreateManualRunMailTaskRequest() (request *ManualRunMailTaskRequest) {
	request = &ManualRunMailTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "ManualRunMailTask", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateManualRunMailTaskResponse creates a response to parse from ManualRunMailTask response
func CreateManualRunMailTaskResponse() (response *ManualRunMailTaskResponse) {
	response = &ManualRunMailTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
