package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetWorksEmbedList invokes the quickbi_public.GetWorksEmbedList API synchronously
func (client *Client) GetWorksEmbedList(request *GetWorksEmbedListRequest) (response *GetWorksEmbedListResponse, err error) {
	response = CreateGetWorksEmbedListResponse()
	err = client.DoAction(request, response)
	return
}

// GetWorksEmbedListWithChan invokes the quickbi_public.GetWorksEmbedList API asynchronously
func (client *Client) GetWorksEmbedListWithChan(request *GetWorksEmbedListRequest) (<-chan *GetWorksEmbedListResponse, <-chan error) {
	responseChan := make(chan *GetWorksEmbedListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetWorksEmbedList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetWorksEmbedListWithCallback invokes the quickbi_public.GetWorksEmbedList API asynchronously
func (client *Client) GetWorksEmbedListWithCallback(request *GetWorksEmbedListRequest, callback func(response *GetWorksEmbedListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetWorksEmbedListResponse
		var err error
		defer close(result)
		response, err = client.GetWorksEmbedList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetWorksEmbedListRequest is the request struct for api GetWorksEmbedList
type GetWorksEmbedListRequest struct {
	*requests.RpcRequest
	WsId        string           `position:"Query" name:"WsId"`
	AccessPoint string           `position:"Query" name:"AccessPoint"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	Keyword     string           `position:"Query" name:"Keyword"`
	WorksType   string           `position:"Query" name:"WorksType"`
	SignType    string           `position:"Query" name:"SignType"`
	PageNo      requests.Integer `position:"Query" name:"PageNo"`
}

// GetWorksEmbedListResponse is the response struct for api GetWorksEmbedList
type GetWorksEmbedListResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateGetWorksEmbedListRequest creates a request to invoke GetWorksEmbedList API
func CreateGetWorksEmbedListRequest() (request *GetWorksEmbedListRequest) {
	request = &GetWorksEmbedListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2022-01-01", "GetWorksEmbedList", "2.2.0", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetWorksEmbedListResponse creates a response to parse from GetWorksEmbedList response
func CreateGetWorksEmbedListResponse() (response *GetWorksEmbedListResponse) {
	response = &GetWorksEmbedListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
