package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateCheckTypeToScheme invokes the qualitycheck.UpdateCheckTypeToScheme API synchronously
func (client *Client) UpdateCheckTypeToScheme(request *UpdateCheckTypeToSchemeRequest) (response *UpdateCheckTypeToSchemeResponse, err error) {
	response = CreateUpdateCheckTypeToSchemeResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateCheckTypeToSchemeWithChan invokes the qualitycheck.UpdateCheckTypeToScheme API asynchronously
func (client *Client) UpdateCheckTypeToSchemeWithChan(request *UpdateCheckTypeToSchemeRequest) (<-chan *UpdateCheckTypeToSchemeResponse, <-chan error) {
	responseChan := make(chan *UpdateCheckTypeToSchemeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateCheckTypeToScheme(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateCheckTypeToSchemeWithCallback invokes the qualitycheck.UpdateCheckTypeToScheme API asynchronously
func (client *Client) UpdateCheckTypeToSchemeWithCallback(request *UpdateCheckTypeToSchemeRequest, callback func(response *UpdateCheckTypeToSchemeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateCheckTypeToSchemeResponse
		var err error
		defer close(result)
		response, err = client.UpdateCheckTypeToScheme(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateCheckTypeToSchemeRequest is the request struct for api UpdateCheckTypeToScheme
type UpdateCheckTypeToSchemeRequest struct {
	*requests.RpcRequest
	JsonStr       string           `position:"Query" name:"jsonStr"`
	BaseMeAgentId requests.Integer `position:"Query" name:"BaseMeAgentId"`
}

// UpdateCheckTypeToSchemeResponse is the response struct for api UpdateCheckTypeToScheme
type UpdateCheckTypeToSchemeResponse struct {
	*responses.BaseResponse
	Data           int64                             `json:"Data" xml:"Data"`
	RequestId      string                            `json:"RequestId" xml:"RequestId"`
	Success        bool                              `json:"Success" xml:"Success"`
	Code           string                            `json:"Code" xml:"Code"`
	Message        string                            `json:"Message" xml:"Message"`
	HttpStatusCode int                               `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Messages       MessagesInUpdateCheckTypeToScheme `json:"Messages" xml:"Messages"`
}

// CreateUpdateCheckTypeToSchemeRequest creates a request to invoke UpdateCheckTypeToScheme API
func CreateUpdateCheckTypeToSchemeRequest() (request *UpdateCheckTypeToSchemeRequest) {
	request = &UpdateCheckTypeToSchemeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "UpdateCheckTypeToScheme", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateCheckTypeToSchemeResponse creates a response to parse from UpdateCheckTypeToScheme response
func CreateUpdateCheckTypeToSchemeResponse() (response *UpdateCheckTypeToSchemeResponse) {
	response = &UpdateCheckTypeToSchemeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
