package qualitycheck

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRulesCountList invokes the qualitycheck.GetRulesCountList API synchronously
func (client *Client) GetRulesCountList(request *GetRulesCountListRequest) (response *GetRulesCountListResponse, err error) {
	response = CreateGetRulesCountListResponse()
	err = client.DoAction(request, response)
	return
}

// GetRulesCountListWithChan invokes the qualitycheck.GetRulesCountList API asynchronously
func (client *Client) GetRulesCountListWithChan(request *GetRulesCountListRequest) (<-chan *GetRulesCountListResponse, <-chan error) {
	responseChan := make(chan *GetRulesCountListResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRulesCountList(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRulesCountListWithCallback invokes the qualitycheck.GetRulesCountList API asynchronously
func (client *Client) GetRulesCountListWithCallback(request *GetRulesCountListRequest, callback func(response *GetRulesCountListResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRulesCountListResponse
		var err error
		defer close(result)
		response, err = client.GetRulesCountList(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRulesCountListRequest is the request struct for api GetRulesCountList
type GetRulesCountListRequest struct {
	*requests.RpcRequest
	CreateEmpid         string           `position:"Body" name:"CreateEmpid"`
	UpdateUserId        requests.Integer `position:"Body" name:"UpdateUserId"`
	UpdateStartTime     string           `position:"Body" name:"UpdateStartTime"`
	StartTime           string           `position:"Body" name:"StartTime"`
	Rid                 requests.Integer `position:"Body" name:"Rid"`
	Type                requests.Integer `position:"Body" name:"Type"`
	PageNumber          requests.Integer `position:"Body" name:"PageNumber"`
	RuleIdOrRuleName    string           `position:"Body" name:"RuleIdOrRuleName"`
	PageSize            requests.Integer `position:"Body" name:"PageSize"`
	CreateUserId        requests.Integer `position:"Body" name:"CreateUserId"`
	RuleScoreSingleType requests.Integer `position:"Body" name:"RuleScoreSingleType"`
	SourceType          requests.Integer `position:"Body" name:"SourceType"`
	UpdateEndTime       string           `position:"Body" name:"UpdateEndTime"`
	IsSchemeData        requests.Integer `position:"Body" name:"IsSchemeData"`
	RuleType            requests.Integer `position:"Body" name:"RuleType"`
	CountTotal          requests.Boolean `position:"Body" name:"CountTotal"`
	EndTime             string           `position:"Body" name:"EndTime"`
	SchemeId            requests.Integer `position:"Body" name:"SchemeId"`
	CurrentPage         requests.Integer `position:"Body" name:"CurrentPage"`
	BusinessRange       requests.Integer `position:"Body" name:"BusinessRange"`
	BusinessName        string           `position:"Body" name:"BusinessName"`
	CategoryName        string           `position:"Body" name:"CategoryName"`
	LastUpdateEmpid     string           `position:"Body" name:"LastUpdateEmpid"`
	BaseMeAgentId       requests.Integer `position:"Query" name:"BaseMeAgentId"`
	TypeName            string           `position:"Body" name:"TypeName"`
	RequireInfos        *[]string        `position:"Body" name:"RequireInfos"  type:"Repeated"`
	Status              requests.Integer `position:"Body" name:"Status"`
}

// GetRulesCountListResponse is the response struct for api GetRulesCountList
type GetRulesCountListResponse struct {
	*responses.BaseResponse
	TotalCount     int                         `json:"TotalCount" xml:"TotalCount"`
	BusinessType   int                         `json:"BusinessType" xml:"BusinessType"`
	Count          int                         `json:"Count" xml:"Count"`
	CurrentPage    int                         `json:"CurrentPage" xml:"CurrentPage"`
	PageSize       int                         `json:"PageSize" xml:"PageSize"`
	PageNumber     int                         `json:"PageNumber" xml:"PageNumber"`
	RequestId      string                      `json:"RequestId" xml:"RequestId"`
	Success        bool                        `json:"Success" xml:"Success"`
	Code           string                      `json:"Code" xml:"Code"`
	Message        string                      `json:"Message" xml:"Message"`
	HttpStatusCode int                         `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           DataInGetRulesCountList     `json:"Data" xml:"Data"`
	Messages       MessagesInGetRulesCountList `json:"Messages" xml:"Messages"`
}

// CreateGetRulesCountListRequest creates a request to invoke GetRulesCountList API
func CreateGetRulesCountListRequest() (request *GetRulesCountListRequest) {
	request = &GetRulesCountListRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Qualitycheck", "2019-01-15", "GetRulesCountList", "", "")
	request.Method = requests.POST
	return
}

// CreateGetRulesCountListResponse creates a response to parse from GetRulesCountList response
func CreateGetRulesCountListResponse() (response *GetRulesCountListResponse) {
	response = &GetRulesCountListResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
