package qianzhou

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetUserClusterWarning invokes the qianzhou.GetUserClusterWarning API synchronously
func (client *Client) GetUserClusterWarning(request *GetUserClusterWarningRequest) (response *GetUserClusterWarningResponse, err error) {
	response = CreateGetUserClusterWarningResponse()
	err = client.DoAction(request, response)
	return
}

// GetUserClusterWarningWithChan invokes the qianzhou.GetUserClusterWarning API asynchronously
func (client *Client) GetUserClusterWarningWithChan(request *GetUserClusterWarningRequest) (<-chan *GetUserClusterWarningResponse, <-chan error) {
	responseChan := make(chan *GetUserClusterWarningResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetUserClusterWarning(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetUserClusterWarningWithCallback invokes the qianzhou.GetUserClusterWarning API asynchronously
func (client *Client) GetUserClusterWarningWithCallback(request *GetUserClusterWarningRequest, callback func(response *GetUserClusterWarningResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetUserClusterWarningResponse
		var err error
		defer close(result)
		response, err = client.GetUserClusterWarning(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetUserClusterWarningRequest is the request struct for api GetUserClusterWarning
type GetUserClusterWarningRequest struct {
	*requests.RoaRequest
	UserID string `position:"Query" name:"userID"`
}

// GetUserClusterWarningResponse is the response struct for api GetUserClusterWarning
type GetUserClusterWarningResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
}

// CreateGetUserClusterWarningRequest creates a request to invoke GetUserClusterWarning API
func CreateGetUserClusterWarningRequest() (request *GetUserClusterWarningRequest) {
	request = &GetUserClusterWarningRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("qianzhou", "2021-11-11", "GetUserClusterWarning", "/popapi/listUserKeyClusters", "", "")
	request.Method = requests.GET
	return
}

// CreateGetUserClusterWarningResponse creates a response to parse from GetUserClusterWarning response
func CreateGetUserClusterWarningResponse() (response *GetUserClusterWarningResponse) {
	response = &GetUserClusterWarningResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
