package qianzhou

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDiagnosisResult invokes the qianzhou.GetDiagnosisResult API synchronously
func (client *Client) GetDiagnosisResult(request *GetDiagnosisResultRequest) (response *GetDiagnosisResultResponse, err error) {
	response = CreateGetDiagnosisResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetDiagnosisResultWithChan invokes the qianzhou.GetDiagnosisResult API asynchronously
func (client *Client) GetDiagnosisResultWithChan(request *GetDiagnosisResultRequest) (<-chan *GetDiagnosisResultResponse, <-chan error) {
	responseChan := make(chan *GetDiagnosisResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDiagnosisResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDiagnosisResultWithCallback invokes the qianzhou.GetDiagnosisResult API asynchronously
func (client *Client) GetDiagnosisResultWithCallback(request *GetDiagnosisResultRequest, callback func(response *GetDiagnosisResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDiagnosisResultResponse
		var err error
		defer close(result)
		response, err = client.GetDiagnosisResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDiagnosisResultRequest is the request struct for api GetDiagnosisResult
type GetDiagnosisResultRequest struct {
	*requests.RoaRequest
	DiagnosisId string `position:"Query" name:"diagnosisId"`
	OwnerUid    string `position:"Query" name:"ownerUid"`
}

// GetDiagnosisResultResponse is the response struct for api GetDiagnosisResult
type GetDiagnosisResultResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Data      string `json:"data" xml:"data"`
	Code      string `json:"code" xml:"code"`
	Msg       string `json:"msg" xml:"msg"`
}

// CreateGetDiagnosisResultRequest creates a request to invoke GetDiagnosisResult API
func CreateGetDiagnosisResultRequest() (request *GetDiagnosisResultRequest) {
	request = &GetDiagnosisResultRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("qianzhou", "2021-11-11", "GetDiagnosisResult", "/popapi/GetDiagnosisResult", "", "")
	request.Method = requests.GET
	return
}

// CreateGetDiagnosisResultResponse creates a response to parse from GetDiagnosisResult response
func CreateGetDiagnosisResultResponse() (response *GetDiagnosisResultResponse) {
	response = &GetDiagnosisResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
