package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SavePtsScene invokes the pts.SavePtsScene API synchronously
func (client *Client) SavePtsScene(request *SavePtsSceneRequest) (response *SavePtsSceneResponse, err error) {
	response = CreateSavePtsSceneResponse()
	err = client.DoAction(request, response)
	return
}

// SavePtsSceneWithChan invokes the pts.SavePtsScene API asynchronously
func (client *Client) SavePtsSceneWithChan(request *SavePtsSceneRequest) (<-chan *SavePtsSceneResponse, <-chan error) {
	responseChan := make(chan *SavePtsSceneResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SavePtsScene(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SavePtsSceneWithCallback invokes the pts.SavePtsScene API asynchronously
func (client *Client) SavePtsSceneWithCallback(request *SavePtsSceneRequest, callback func(response *SavePtsSceneResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SavePtsSceneResponse
		var err error
		defer close(result)
		response, err = client.SavePtsScene(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SavePtsSceneRequest is the request struct for api SavePtsScene
type SavePtsSceneRequest struct {
	*requests.RpcRequest
	Scene string `position:"Query" name:"Scene"`
}

// SavePtsSceneResponse is the response struct for api SavePtsScene
type SavePtsSceneResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	SceneId        string `json:"SceneId" xml:"SceneId"`
}

// CreateSavePtsSceneRequest creates a request to invoke SavePtsScene API
func CreateSavePtsSceneRequest() (request *SavePtsSceneRequest) {
	request = &SavePtsSceneRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "SavePtsScene", "", "")
	request.Method = requests.POST
	return
}

// CreateSavePtsSceneResponse creates a response to parse from SavePtsScene response
func CreateSavePtsSceneResponse() (response *SavePtsSceneResponse) {
	response = &SavePtsSceneResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
