package pts

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AdjustJMeterSceneSpeed invokes the pts.AdjustJMeterSceneSpeed API synchronously
func (client *Client) AdjustJMeterSceneSpeed(request *AdjustJMeterSceneSpeedRequest) (response *AdjustJMeterSceneSpeedResponse, err error) {
	response = CreateAdjustJMeterSceneSpeedResponse()
	err = client.DoAction(request, response)
	return
}

// AdjustJMeterSceneSpeedWithChan invokes the pts.AdjustJMeterSceneSpeed API asynchronously
func (client *Client) AdjustJMeterSceneSpeedWithChan(request *AdjustJMeterSceneSpeedRequest) (<-chan *AdjustJMeterSceneSpeedResponse, <-chan error) {
	responseChan := make(chan *AdjustJMeterSceneSpeedResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AdjustJMeterSceneSpeed(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AdjustJMeterSceneSpeedWithCallback invokes the pts.AdjustJMeterSceneSpeed API asynchronously
func (client *Client) AdjustJMeterSceneSpeedWithCallback(request *AdjustJMeterSceneSpeedRequest, callback func(response *AdjustJMeterSceneSpeedResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AdjustJMeterSceneSpeedResponse
		var err error
		defer close(result)
		response, err = client.AdjustJMeterSceneSpeed(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AdjustJMeterSceneSpeedRequest is the request struct for api AdjustJMeterSceneSpeed
type AdjustJMeterSceneSpeedRequest struct {
	*requests.RpcRequest
	ReportId string           `position:"Query" name:"ReportId"`
	Speed    requests.Integer `position:"Query" name:"Speed"`
}

// AdjustJMeterSceneSpeedResponse is the response struct for api AdjustJMeterSceneSpeed
type AdjustJMeterSceneSpeedResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	ReportId       string `json:"ReportId" xml:"ReportId"`
}

// CreateAdjustJMeterSceneSpeedRequest creates a request to invoke AdjustJMeterSceneSpeed API
func CreateAdjustJMeterSceneSpeedRequest() (request *AdjustJMeterSceneSpeedRequest) {
	request = &AdjustJMeterSceneSpeedRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("PTS", "2020-10-20", "AdjustJMeterSceneSpeed", "", "")
	request.Method = requests.POST
	return
}

// CreateAdjustJMeterSceneSpeedResponse creates a response to parse from AdjustJMeterSceneSpeed response
func CreateAdjustJMeterSceneSpeedResponse() (response *AdjustJMeterSceneSpeedResponse) {
	response = &AdjustJMeterSceneSpeedResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
