package polardbx

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBackupSet invokes the polardbx.DescribeBackupSet API synchronously
func (client *Client) DescribeBackupSet(request *DescribeBackupSetRequest) (response *DescribeBackupSetResponse, err error) {
	response = CreateDescribeBackupSetResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBackupSetWithChan invokes the polardbx.DescribeBackupSet API asynchronously
func (client *Client) DescribeBackupSetWithChan(request *DescribeBackupSetRequest) (<-chan *DescribeBackupSetResponse, <-chan error) {
	responseChan := make(chan *DescribeBackupSetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBackupSet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBackupSetWithCallback invokes the polardbx.DescribeBackupSet API asynchronously
func (client *Client) DescribeBackupSetWithCallback(request *DescribeBackupSetRequest, callback func(response *DescribeBackupSetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBackupSetResponse
		var err error
		defer close(result)
		response, err = client.DescribeBackupSet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBackupSetRequest is the request struct for api DescribeBackupSet
type DescribeBackupSetRequest struct {
	*requests.RpcRequest
	DBInstanceName  string `position:"Query" name:"DBInstanceName"`
	BackupSetId     string `position:"Query" name:"BackupSetId"`
	DestCrossRegion string `position:"Query" name:"DestCrossRegion"`
}

// DescribeBackupSetResponse is the response struct for api DescribeBackupSet
type DescribeBackupSetResponse struct {
	*responses.BaseResponse
	Message   string      `json:"Message" xml:"Message"`
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Success   bool        `json:"Success" xml:"Success"`
	Data      []BackupSet `json:"Data" xml:"Data"`
}

// CreateDescribeBackupSetRequest creates a request to invoke DescribeBackupSet API
func CreateDescribeBackupSetRequest() (request *DescribeBackupSetRequest) {
	request = &DescribeBackupSetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardbx", "2020-02-02", "DescribeBackupSet", "polardbx", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBackupSetResponse creates a response to parse from DescribeBackupSet response
func CreateDescribeBackupSetResponse() (response *DescribeBackupSetResponse) {
	response = &DescribeBackupSetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
