package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetGlobalDatabaseNetwork invokes the polardb.ResetGlobalDatabaseNetwork API synchronously
func (client *Client) ResetGlobalDatabaseNetwork(request *ResetGlobalDatabaseNetworkRequest) (response *ResetGlobalDatabaseNetworkResponse, err error) {
	response = CreateResetGlobalDatabaseNetworkResponse()
	err = client.DoAction(request, response)
	return
}

// ResetGlobalDatabaseNetworkWithChan invokes the polardb.ResetGlobalDatabaseNetwork API asynchronously
func (client *Client) ResetGlobalDatabaseNetworkWithChan(request *ResetGlobalDatabaseNetworkRequest) (<-chan *ResetGlobalDatabaseNetworkResponse, <-chan error) {
	responseChan := make(chan *ResetGlobalDatabaseNetworkResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetGlobalDatabaseNetwork(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetGlobalDatabaseNetworkWithCallback invokes the polardb.ResetGlobalDatabaseNetwork API asynchronously
func (client *Client) ResetGlobalDatabaseNetworkWithCallback(request *ResetGlobalDatabaseNetworkRequest, callback func(response *ResetGlobalDatabaseNetworkResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetGlobalDatabaseNetworkResponse
		var err error
		defer close(result)
		response, err = client.ResetGlobalDatabaseNetwork(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetGlobalDatabaseNetworkRequest is the request struct for api ResetGlobalDatabaseNetwork
type ResetGlobalDatabaseNetworkRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	GDNId                string           `position:"Query" name:"GDNId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	DBClusterId          string           `position:"Query" name:"DBClusterId"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ResetGlobalDatabaseNetworkResponse is the response struct for api ResetGlobalDatabaseNetwork
type ResetGlobalDatabaseNetworkResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateResetGlobalDatabaseNetworkRequest creates a request to invoke ResetGlobalDatabaseNetwork API
func CreateResetGlobalDatabaseNetworkRequest() (request *ResetGlobalDatabaseNetworkRequest) {
	request = &ResetGlobalDatabaseNetworkRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "ResetGlobalDatabaseNetwork", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateResetGlobalDatabaseNetworkResponse creates a response to parse from ResetGlobalDatabaseNetwork response
func CreateResetGlobalDatabaseNetworkResponse() (response *ResetGlobalDatabaseNetworkResponse) {
	response = &ResetGlobalDatabaseNetworkResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
