package polardb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CancelActiveOperationTasks invokes the polardb.CancelActiveOperationTasks API synchronously
func (client *Client) CancelActiveOperationTasks(request *CancelActiveOperationTasksRequest) (response *CancelActiveOperationTasksResponse, err error) {
	response = CreateCancelActiveOperationTasksResponse()
	err = client.DoAction(request, response)
	return
}

// CancelActiveOperationTasksWithChan invokes the polardb.CancelActiveOperationTasks API asynchronously
func (client *Client) CancelActiveOperationTasksWithChan(request *CancelActiveOperationTasksRequest) (<-chan *CancelActiveOperationTasksResponse, <-chan error) {
	responseChan := make(chan *CancelActiveOperationTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CancelActiveOperationTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CancelActiveOperationTasksWithCallback invokes the polardb.CancelActiveOperationTasks API asynchronously
func (client *Client) CancelActiveOperationTasksWithCallback(request *CancelActiveOperationTasksRequest, callback func(response *CancelActiveOperationTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CancelActiveOperationTasksResponse
		var err error
		defer close(result)
		response, err = client.CancelActiveOperationTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CancelActiveOperationTasksRequest is the request struct for api CancelActiveOperationTasks
type CancelActiveOperationTasksRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TaskIds              string           `position:"Query" name:"TaskIds"`
	Uid                  string           `position:"Query" name:"Uid"`
	ResourceGroupId      string           `position:"Query" name:"ResourceGroupId"`
	SecurityToken        string           `position:"Query" name:"SecurityToken"`
	EngineType           string           `position:"Query" name:"EngineType"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// CancelActiveOperationTasksResponse is the response struct for api CancelActiveOperationTasks
type CancelActiveOperationTasksResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskIds   string `json:"TaskIds" xml:"TaskIds"`
}

// CreateCancelActiveOperationTasksRequest creates a request to invoke CancelActiveOperationTasks API
func CreateCancelActiveOperationTasksRequest() (request *CancelActiveOperationTasksRequest) {
	request = &CancelActiveOperationTasksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("polardb", "2017-08-01", "CancelActiveOperationTasks", "polardb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCancelActiveOperationTasksResponse creates a response to parse from CancelActiveOperationTasks response
func CreateCancelActiveOperationTasksResponse() (response *CancelActiveOperationTasksResponse) {
	response = &CancelActiveOperationTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
