package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListTrafficControlTargetTrafficHistory invokes the pairecservice.ListTrafficControlTargetTrafficHistory API synchronously
func (client *Client) ListTrafficControlTargetTrafficHistory(request *ListTrafficControlTargetTrafficHistoryRequest) (response *ListTrafficControlTargetTrafficHistoryResponse, err error) {
	response = CreateListTrafficControlTargetTrafficHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// ListTrafficControlTargetTrafficHistoryWithChan invokes the pairecservice.ListTrafficControlTargetTrafficHistory API asynchronously
func (client *Client) ListTrafficControlTargetTrafficHistoryWithChan(request *ListTrafficControlTargetTrafficHistoryRequest) (<-chan *ListTrafficControlTargetTrafficHistoryResponse, <-chan error) {
	responseChan := make(chan *ListTrafficControlTargetTrafficHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListTrafficControlTargetTrafficHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListTrafficControlTargetTrafficHistoryWithCallback invokes the pairecservice.ListTrafficControlTargetTrafficHistory API asynchronously
func (client *Client) ListTrafficControlTargetTrafficHistoryWithCallback(request *ListTrafficControlTargetTrafficHistoryRequest, callback func(response *ListTrafficControlTargetTrafficHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListTrafficControlTargetTrafficHistoryResponse
		var err error
		defer close(result)
		response, err = client.ListTrafficControlTargetTrafficHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListTrafficControlTargetTrafficHistoryRequest is the request struct for api ListTrafficControlTargetTrafficHistory
type ListTrafficControlTargetTrafficHistoryRequest struct {
	*requests.RoaRequest
	Threshold              string `position:"Query" name:"Threshold"`
	TrafficControlTargetId string `position:"Path" name:"TrafficControlTargetId"`
	StartTime              string `position:"Query" name:"StartTime"`
	ItemId                 string `position:"Query" name:"ItemId"`
	ExperimentGroupId      string `position:"Query" name:"ExperimentGroupId"`
	EndTime                string `position:"Query" name:"EndTime"`
	Environment            string `position:"Query" name:"Environment"`
	InstanceId             string `position:"Query" name:"InstanceId"`
	ExperimentId           string `position:"Query" name:"ExperimentId"`
}

// ListTrafficControlTargetTrafficHistoryResponse is the response struct for api ListTrafficControlTargetTrafficHistory
type ListTrafficControlTargetTrafficHistoryResponse struct {
	*responses.BaseResponse
	RequestId                          string                                   `json:"RequestId" xml:"RequestId"`
	TotalCount                         string                                   `json:"TotalCount" xml:"TotalCount"`
	TrafficControlTaskTrafficHistories []TrafficControlTaskTrafficHistoriesItem `json:"TrafficControlTaskTrafficHistories" xml:"TrafficControlTaskTrafficHistories"`
}

// CreateListTrafficControlTargetTrafficHistoryRequest creates a request to invoke ListTrafficControlTargetTrafficHistory API
func CreateListTrafficControlTargetTrafficHistoryRequest() (request *ListTrafficControlTargetTrafficHistoryRequest) {
	request = &ListTrafficControlTargetTrafficHistoryRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListTrafficControlTargetTrafficHistory", "/api/v1/trafficcontroltargets/[TrafficControlTargetId]/traffichistories", "", "")
	request.Method = requests.GET
	return
}

// CreateListTrafficControlTargetTrafficHistoryResponse creates a response to parse from ListTrafficControlTargetTrafficHistory response
func CreateListTrafficControlTargetTrafficHistoryResponse() (response *ListTrafficControlTargetTrafficHistoryResponse) {
	response = &ListTrafficControlTargetTrafficHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
