package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListFeatureConsistencyCheckJobFeatureReports invokes the pairecservice.ListFeatureConsistencyCheckJobFeatureReports API synchronously
func (client *Client) ListFeatureConsistencyCheckJobFeatureReports(request *ListFeatureConsistencyCheckJobFeatureReportsRequest) (response *ListFeatureConsistencyCheckJobFeatureReportsResponse, err error) {
	response = CreateListFeatureConsistencyCheckJobFeatureReportsResponse()
	err = client.DoAction(request, response)
	return
}

// ListFeatureConsistencyCheckJobFeatureReportsWithChan invokes the pairecservice.ListFeatureConsistencyCheckJobFeatureReports API asynchronously
func (client *Client) ListFeatureConsistencyCheckJobFeatureReportsWithChan(request *ListFeatureConsistencyCheckJobFeatureReportsRequest) (<-chan *ListFeatureConsistencyCheckJobFeatureReportsResponse, <-chan error) {
	responseChan := make(chan *ListFeatureConsistencyCheckJobFeatureReportsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListFeatureConsistencyCheckJobFeatureReports(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListFeatureConsistencyCheckJobFeatureReportsWithCallback invokes the pairecservice.ListFeatureConsistencyCheckJobFeatureReports API asynchronously
func (client *Client) ListFeatureConsistencyCheckJobFeatureReportsWithCallback(request *ListFeatureConsistencyCheckJobFeatureReportsRequest, callback func(response *ListFeatureConsistencyCheckJobFeatureReportsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListFeatureConsistencyCheckJobFeatureReportsResponse
		var err error
		defer close(result)
		response, err = client.ListFeatureConsistencyCheckJobFeatureReports(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListFeatureConsistencyCheckJobFeatureReportsRequest is the request struct for api ListFeatureConsistencyCheckJobFeatureReports
type ListFeatureConsistencyCheckJobFeatureReportsRequest struct {
	*requests.RoaRequest
	LogRequestId                 string `position:"Query" name:"LogRequestId"`
	LogUserId                    string `position:"Query" name:"LogUserId"`
	LogItemId                    string `position:"Query" name:"LogItemId"`
	InstanceId                   string `position:"Query" name:"InstanceId"`
	FeatureConsistencyCheckJobId string `position:"Path" name:"FeatureConsistencyCheckJobId"`
}

// ListFeatureConsistencyCheckJobFeatureReportsResponse is the response struct for api ListFeatureConsistencyCheckJobFeatureReports
type ListFeatureConsistencyCheckJobFeatureReportsResponse struct {
	*responses.BaseResponse
	RequestId            string                     `json:"RequestId" xml:"RequestId"`
	DataPath             string                     `json:"DataPath" xml:"DataPath"`
	OssPath              string                     `json:"OssPath" xml:"OssPath"`
	ReportsOfFeatureDiff []ReportsOfFeatureDiffItem `json:"ReportsOfFeatureDiff" xml:"ReportsOfFeatureDiff"`
}

// CreateListFeatureConsistencyCheckJobFeatureReportsRequest creates a request to invoke ListFeatureConsistencyCheckJobFeatureReports API
func CreateListFeatureConsistencyCheckJobFeatureReportsRequest() (request *ListFeatureConsistencyCheckJobFeatureReportsRequest) {
	request = &ListFeatureConsistencyCheckJobFeatureReportsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "ListFeatureConsistencyCheckJobFeatureReports", "/api/v1/featureconsistencycheck/jobs/[FeatureConsistencyCheckJobId]/featurereports", "", "")
	request.Method = requests.GET
	return
}

// CreateListFeatureConsistencyCheckJobFeatureReportsResponse creates a response to parse from ListFeatureConsistencyCheckJobFeatureReports response
func CreateListFeatureConsistencyCheckJobFeatureReportsResponse() (response *ListFeatureConsistencyCheckJobFeatureReportsResponse) {
	response = &ListFeatureConsistencyCheckJobFeatureReportsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
