package outboundbot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTenantBindNumber invokes the outboundbot.DescribeTenantBindNumber API synchronously
func (client *Client) DescribeTenantBindNumber(request *DescribeTenantBindNumberRequest) (response *DescribeTenantBindNumberResponse, err error) {
	response = CreateDescribeTenantBindNumberResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTenantBindNumberWithChan invokes the outboundbot.DescribeTenantBindNumber API asynchronously
func (client *Client) DescribeTenantBindNumberWithChan(request *DescribeTenantBindNumberRequest) (<-chan *DescribeTenantBindNumberResponse, <-chan error) {
	responseChan := make(chan *DescribeTenantBindNumberResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTenantBindNumber(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTenantBindNumberWithCallback invokes the outboundbot.DescribeTenantBindNumber API asynchronously
func (client *Client) DescribeTenantBindNumberWithCallback(request *DescribeTenantBindNumberRequest, callback func(response *DescribeTenantBindNumberResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTenantBindNumberResponse
		var err error
		defer close(result)
		response, err = client.DescribeTenantBindNumber(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTenantBindNumberRequest is the request struct for api DescribeTenantBindNumber
type DescribeTenantBindNumberRequest struct {
	*requests.RpcRequest
	Number string `position:"Query" name:"Number"`
}

// DescribeTenantBindNumberResponse is the response struct for api DescribeTenantBindNumber
type DescribeTenantBindNumberResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateDescribeTenantBindNumberRequest creates a request to invoke DescribeTenantBindNumber API
func CreateDescribeTenantBindNumberRequest() (request *DescribeTenantBindNumberRequest) {
	request = &DescribeTenantBindNumberRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OutboundBot", "2019-12-26", "DescribeTenantBindNumber", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeTenantBindNumberResponse creates a response to parse from DescribeTenantBindNumber response
func CreateDescribeTenantBindNumberResponse() (response *DescribeTenantBindNumberResponse) {
	response = &DescribeTenantBindNumberResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
