package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RemoveScheduledTask invokes the opensearch.RemoveScheduledTask API synchronously
func (client *Client) RemoveScheduledTask(request *RemoveScheduledTaskRequest) (response *RemoveScheduledTaskResponse, err error) {
	response = CreateRemoveScheduledTaskResponse()
	err = client.DoAction(request, response)
	return
}

// RemoveScheduledTaskWithChan invokes the opensearch.RemoveScheduledTask API asynchronously
func (client *Client) RemoveScheduledTaskWithChan(request *RemoveScheduledTaskRequest) (<-chan *RemoveScheduledTaskResponse, <-chan error) {
	responseChan := make(chan *RemoveScheduledTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RemoveScheduledTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RemoveScheduledTaskWithCallback invokes the opensearch.RemoveScheduledTask API asynchronously
func (client *Client) RemoveScheduledTaskWithCallback(request *RemoveScheduledTaskRequest, callback func(response *RemoveScheduledTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RemoveScheduledTaskResponse
		var err error
		defer close(result)
		response, err = client.RemoveScheduledTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RemoveScheduledTaskRequest is the request struct for api RemoveScheduledTask
type RemoveScheduledTaskRequest struct {
	*requests.RoaRequest
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
	TaskId           string `position:"Path" name:"taskId"`
}

// RemoveScheduledTaskResponse is the response struct for api RemoveScheduledTask
type RemoveScheduledTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"requestId" xml:"requestId"`
	Result    []int  `json:"result" xml:"result"`
}

// CreateRemoveScheduledTaskRequest creates a request to invoke RemoveScheduledTask API
func CreateRemoveScheduledTaskRequest() (request *RemoveScheduledTaskRequest) {
	request = &RemoveScheduledTaskRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "RemoveScheduledTask", "/v4/openapi/app-groups/[appGroupIdentity]/scheduled-tasks/[taskId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateRemoveScheduledTaskResponse creates a response to parse from RemoveScheduledTask response
func CreateRemoveScheduledTaskResponse() (response *RemoveScheduledTaskResponse) {
	response = &RemoveScheduledTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
