package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteFunctionTask invokes the opensearch.DeleteFunctionTask API synchronously
func (client *Client) DeleteFunctionTask(request *DeleteFunctionTaskRequest) (response *DeleteFunctionTaskResponse, err error) {
	response = CreateDeleteFunctionTaskResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteFunctionTaskWithChan invokes the opensearch.DeleteFunctionTask API asynchronously
func (client *Client) DeleteFunctionTaskWithChan(request *DeleteFunctionTaskRequest) (<-chan *DeleteFunctionTaskResponse, <-chan error) {
	responseChan := make(chan *DeleteFunctionTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteFunctionTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteFunctionTaskWithCallback invokes the opensearch.DeleteFunctionTask API asynchronously
func (client *Client) DeleteFunctionTaskWithCallback(request *DeleteFunctionTaskRequest, callback func(response *DeleteFunctionTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteFunctionTaskResponse
		var err error
		defer close(result)
		response, err = client.DeleteFunctionTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteFunctionTaskRequest is the request struct for api DeleteFunctionTask
type DeleteFunctionTaskRequest struct {
	*requests.RoaRequest
	Generation       string `position:"Path" name:"generation"`
	InstanceName     string `position:"Path" name:"instanceName"`
	FunctionName     string `position:"Path" name:"functionName"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// DeleteFunctionTaskResponse is the response struct for api DeleteFunctionTask
type DeleteFunctionTaskResponse struct {
	*responses.BaseResponse
	Status    string `json:"Status" xml:"Status"`
	HttpCode  int64  `json:"HttpCode" xml:"HttpCode"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Latency   int64  `json:"Latency" xml:"Latency"`
}

// CreateDeleteFunctionTaskRequest creates a request to invoke DeleteFunctionTask API
func CreateDeleteFunctionTaskRequest() (request *DeleteFunctionTaskRequest) {
	request = &DeleteFunctionTaskRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "DeleteFunctionTask", "/v4/openapi/app-groups/[appGroupIdentity]/functions/[functionName]/instances/[instanceName]/tasks/[generation]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteFunctionTaskResponse creates a response to parse from DeleteFunctionTask response
func CreateDeleteFunctionTaskResponse() (response *DeleteFunctionTaskResponse) {
	response = &DeleteFunctionTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
