package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindESUserAnalyzer invokes the opensearch.BindESUserAnalyzer API synchronously
func (client *Client) BindESUserAnalyzer(request *BindESUserAnalyzerRequest) (response *BindESUserAnalyzerResponse, err error) {
	response = CreateBindESUserAnalyzerResponse()
	err = client.DoAction(request, response)
	return
}

// BindESUserAnalyzerWithChan invokes the opensearch.BindESUserAnalyzer API asynchronously
func (client *Client) BindESUserAnalyzerWithChan(request *BindESUserAnalyzerRequest) (<-chan *BindESUserAnalyzerResponse, <-chan error) {
	responseChan := make(chan *BindESUserAnalyzerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindESUserAnalyzer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindESUserAnalyzerWithCallback invokes the opensearch.BindESUserAnalyzer API asynchronously
func (client *Client) BindESUserAnalyzerWithCallback(request *BindESUserAnalyzerRequest, callback func(response *BindESUserAnalyzerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindESUserAnalyzerResponse
		var err error
		defer close(result)
		response, err = client.BindESUserAnalyzer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindESUserAnalyzerRequest is the request struct for api BindESUserAnalyzer
type BindESUserAnalyzerRequest struct {
	*requests.RoaRequest
	EsInstanceId     string `position:"Path" name:"esInstanceId"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// BindESUserAnalyzerResponse is the response struct for api BindESUserAnalyzer
type BindESUserAnalyzerResponse struct {
	*responses.BaseResponse
	Result    map[string]interface{} `json:"result" xml:"result"`
	RequestId string                 `json:"requestId" xml:"requestId"`
}

// CreateBindESUserAnalyzerRequest creates a request to invoke BindESUserAnalyzer API
func CreateBindESUserAnalyzerRequest() (request *BindESUserAnalyzerRequest) {
	request = &BindESUserAnalyzerRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "BindESUserAnalyzer", "/v4/openapi/app-groups/[appGroupIdentity]/es/[esInstanceId]/actions/bind-analyzer", "", "")
	request.Method = requests.POST
	return
}

// CreateBindESUserAnalyzerResponse creates a response to parse from BindESUserAnalyzer response
func CreateBindESUserAnalyzerResponse() (response *BindESUserAnalyzerResponse) {
	response = &BindESUserAnalyzerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
